/*
 * Decompiled with CFR 0.152.
 */
package nel.bettershield.entity;

import nel.bettershield.BetterShieldConfig;
import nel.bettershield.Bettershield;
import nel.bettershield.registry.BetterShieldCriteria;
import nel.bettershield.registry.BetterShieldEnchantments;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;

public class ThrownShieldEntity
extends class_1665 {
    private static final class_2940<class_1799> SHIELD_STACK = class_2945.method_12791(ThrownShieldEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> IS_OFFHAND = class_2945.method_12791(ThrownShieldEntity.class, (class_2941)class_2943.field_13323);
    private boolean returning = false;
    private float impactDamage = 2.0f;
    private boolean stunEnabled = false;
    private int entitiesHitCount = 0;

    public ThrownShieldEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ThrownShieldEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(Bettershield.THROWN_SHIELD_ENTITY_TYPE, owner, world);
        this.setStack(stack);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHIELD_STACK, (Object)new class_1799((class_1935)class_1802.field_8255));
        this.field_6011.method_12784(IS_OFFHAND, (Object)false);
    }

    public void setStack(class_1799 stack) {
        this.field_6011.method_12778(SHIELD_STACK, (Object)stack);
    }

    public class_1799 getStack() {
        return (class_1799)this.field_6011.method_12789(SHIELD_STACK);
    }

    public void setOriginalSlot(boolean isOffhand) {
        this.field_6011.method_12778(IS_OFFHAND, (Object)isOffhand);
    }

    public void setImpactDamage(float damage) {
        this.impactDamage = damage;
    }

    public void setStunEnabled(boolean enabled) {
        this.stunEnabled = enabled;
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.returning = true;
        }
        class_1297 owner = this.method_24921();
        BetterShieldConfig config = Bettershield.getConfig();
        double maxRange = config.combat.shieldThrowRange;
        if (owner != null && !this.returning && (double)this.method_5739(owner) > maxRange) {
            this.returning = true;
        }
        if ((this.returning || this.method_7441()) && owner != null) {
            this.method_7433(true);
            this.field_7572 = class_1665.class_1666.field_7592;
            class_243 ownerPos = owner.method_33571().method_1023(0.0, 0.5, 0.0);
            class_243 toOwner = ownerPos.method_1020(this.method_19538());
            double distance = toOwner.method_1033();
            this.method_23327(this.method_23317(), this.method_23318() + toOwner.field_1351 * 0.015, this.method_23321());
            if (this.method_37908().field_9236) {
                this.field_5971 = this.method_23318();
            }
            double speed = 0.5;
            double drag = 0.95;
            if (distance < 5.0) {
                drag = 0.8;
            }
            this.method_18799(this.method_18798().method_1021(drag).method_1019(toOwner.method_1029().method_1021(speed)));
            if (distance < 2.0 && !owner.method_7325()) {
                this.tryCatchShield(owner);
            }
        }
        super.method_5773();
    }

    public void method_5694(class_1657 player) {
        if (this.field_6012 < 5) {
            return;
        }
        if (!(!this.method_34714((class_1297)player) && this.method_24921() != null || this.returning || this.method_37908().field_9236)) {
            this.tryCatchShield((class_1297)player);
        }
    }

    private void tryCatchShield(class_1297 owner) {
        if (!this.method_37908().field_9236 && owner instanceof class_1657) {
            class_1657 player = (class_1657)owner;
            class_1799 shield = this.getStack();
            boolean wasOffhand = (Boolean)this.field_6011.method_12789(IS_OFFHAND);
            if (wasOffhand) {
                class_1799 currentItem = player.method_6079();
                if (currentItem.method_7960()) {
                    player.method_6122(class_1268.field_5810, shield);
                } else if (player.method_31548().method_7394(currentItem)) {
                    player.method_6122(class_1268.field_5810, shield);
                } else {
                    player.method_7328(currentItem, false);
                    player.method_6122(class_1268.field_5810, shield);
                }
            } else if (player.method_6047().method_7960()) {
                player.method_6122(class_1268.field_5808, shield);
            } else if (!player.method_31548().method_7394(shield)) {
                player.method_7328(shield, false);
            }
            this.method_31472();
            player.method_5783(class_3417.field_14698, 1.0f, 1.0f);
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        if (this.field_6012 < 3 && entityHitResult.method_17782() == this.method_24921()) {
            return;
        }
        if (this.returning) {
            return;
        }
        class_1297 target = entityHitResult.method_17782();
        float damage = this.impactDamage;
        int density = class_1890.method_8225((class_1887)BetterShieldEnchantments.SHIELD_DENSITY, (class_1799)this.getStack());
        damage += damage * ((float)density * 0.1f);
        class_1297 owner = this.method_24921();
        if (owner instanceof class_1309) {
            class_1799 stack;
            class_1309 livingOwner = (class_1309)owner;
            target.method_5643(this.method_48923().method_48799((class_1297)this, (class_1297)livingOwner), damage);
            if (this.stunEnabled && target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                BetterShieldConfig config = Bettershield.getConfig();
                livingTarget.method_6092(new class_1293(Bettershield.STUN_EFFECT, config.stunMechanics.stunDuration, 0, false, false, true));
                class_2540 stunBuf = PacketByteBufs.create();
                stunBuf.writeInt(livingTarget.method_5628());
                stunBuf.writeInt(config.stunMechanics.stunDuration);
                if (!this.method_37908().field_9236) {
                    this.method_37908().method_18456().forEach(p -> ServerPlayNetworking.send((class_3222)((class_3222)p), (class_2960)Bettershield.PACKET_STUN_MOBS, (class_2540)stunBuf));
                }
            }
            if (owner instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)owner;
                if (class_1890.method_8225((class_1887)class_1893.field_9120, (class_1799)this.getStack()) > 0) {
                    BetterShieldCriteria.SHIELD_THROW_HIT.trigger(serverPlayer);
                }
                if (this.entitiesHitCount == 2) {
                    BetterShieldCriteria.CAPTAIN_AMERICA.trigger(serverPlayer);
                }
            }
            if ((stack = this.getStack()).method_7963()) {
                stack.method_7974(stack.method_7919() + 2);
                if (stack.method_7919() >= stack.method_7936()) {
                    this.method_31472();
                    this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15239, class_3419.field_15248, 1.0f, 1.0f);
                    return;
                }
                this.setStack(stack);
            }
        } else {
            target.method_5643(this.method_48923().method_48811((class_1297)this, this.method_24921()), damage);
        }
        int piercingLevel = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)this.getStack());
        ++this.entitiesHitCount;
        if (this.entitiesHitCount > piercingLevel) {
            this.returning = true;
            this.method_18799(this.method_18798().method_1021(-0.1));
        } else {
            this.method_18799(this.method_18798().method_1021(0.95));
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15213, class_3419.field_15248, 1.0f, 2.0f);
        }
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            this.returning = true;
        }
    }

    protected class_1799 method_7445() {
        return this.getStack();
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("Shield", (class_2520)this.getStack().method_7953(new class_2487()));
        nbt.method_10556("Returning", this.returning);
        nbt.method_10556("IsOffhand", ((Boolean)this.field_6011.method_12789(IS_OFFHAND)).booleanValue());
        nbt.method_10548("ImpactDamage", this.impactDamage);
        nbt.method_10556("StunEnabled", this.stunEnabled);
        nbt.method_10569("EntitiesHit", this.entitiesHitCount);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Shield", 10)) {
            this.setStack(class_1799.method_7915((class_2487)nbt.method_10562("Shield")));
        }
        this.returning = nbt.method_10577("Returning");
        this.field_6011.method_12778(IS_OFFHAND, (Object)nbt.method_10577("IsOffhand"));
        if (nbt.method_10545("ImpactDamage")) {
            this.impactDamage = nbt.method_10583("ImpactDamage");
        }
        this.stunEnabled = nbt.method_10577("StunEnabled");
        this.entitiesHitCount = nbt.method_10550("EntitiesHit");
    }
}

