/*
 * Decompiled with CFR 0.152.
 */
package com.savaru.inv.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.savaru.inv.config.RulesManager;
import com.savaru.inv.grid.Footprint;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public final class SavaruInvCommands {
    private SavaruInvCommands() {
    }

    public static void register(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"savaruinv").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"reload").executes(ctx -> {
            try {
                RulesManager.reload();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"[SavaruInv] Reloaded rules.json"), false);
                return 1;
            }
            catch (Exception e) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("[SavaruInv] Reload failed: " + e.getMessage())));
                return 0;
            }
        }))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            List<String> lines = RulesManager.listRules();
            if (lines.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"[SavaruInv] No overrides. (rules.json empty)"), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] Overrides (" + lines.size() + "):")), false);
            for (String line : lines) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("  " + line)), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(class_2170.method_9247((String)"hand").executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            class_1799 hand = p.method_6047();
            Footprint fp = RulesManager.getFootprint(hand);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] hand=" + String.valueOf(SavaruInvCommands.idOf(hand)) + " size=" + fp.w() + "x" + fp.h())), false);
            return 1;
        }))).then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String s = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            class_2960 id = class_2960.method_12829((String)s);
            if (id == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("[SavaruInv] Invalid id: " + s)));
                return 0;
            }
            Footprint fp = RulesManager.getFootprintByItemId(id);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] item=" + String.valueOf(id) + " size=" + fp.w() + "x" + fp.h())), false);
            return 1;
        })))).then(class_2170.method_9247((String)"tag").then(class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String s = StringArgumentType.getString((CommandContext)ctx, (String)"tag");
            String norm = SavaruInvCommands.normalizeTag(s);
            if (norm == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("[SavaruInv] Invalid tag: " + s)));
                return 0;
            }
            Footprint fp = RulesManager.getFootprintByTagString(norm);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] tag=#" + norm + " size=" + fp.w() + "x" + fp.h())), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"size").then(class_2170.method_9247((String)"hand").then(class_2170.method_9244((String)"w", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).then(class_2170.method_9244((String)"h", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(ctx -> {
            int h;
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            class_1799 hand = p.method_6047();
            class_2960 id = SavaruInvCommands.idOf(hand);
            if (id == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[SavaruInv] No item in hand."));
                return 0;
            }
            int w = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"w");
            if (RulesManager.setItemRule(id, w, h = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"h"))) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] Set " + String.valueOf(id) + " => " + w + "x" + h)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[SavaruInv] Failed to set rule."));
            return 0;
        }))))).then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"w", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).then(class_2170.method_9244((String)"h", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(ctx -> {
            int h;
            String s = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            class_2960 id = class_2960.method_12829((String)s);
            if (id == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("[SavaruInv] Invalid id: " + s)));
                return 0;
            }
            int w = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"w");
            if (RulesManager.setItemRule(id, w, h = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"h"))) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] Set " + String.valueOf(id) + " => " + w + "x" + h)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[SavaruInv] Failed to set rule."));
            return 0;
        })))))).then(class_2170.method_9247((String)"tag").then(class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"w", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).then(class_2170.method_9244((String)"h", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(ctx -> {
            int h;
            String s = StringArgumentType.getString((CommandContext)ctx, (String)"tag");
            String norm = SavaruInvCommands.normalizeTag(s);
            if (norm == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("[SavaruInv] Invalid tag: " + s)));
                return 0;
            }
            int w = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"w");
            if (RulesManager.setTagRule(norm, w, h = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"h"))) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] Set #" + norm + " => " + w + "x" + h)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[SavaruInv] Failed to set rule."));
            return 0;
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").then(class_2170.method_9247((String)"hand").executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            class_1799 hand = p.method_6047();
            class_2960 id = SavaruInvCommands.idOf(hand);
            if (id == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[SavaruInv] No item in hand."));
                return 0;
            }
            if (RulesManager.clearItemRule(id)) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] Cleared " + String.valueOf(id))), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[SavaruInv] Nothing to clear."));
            return 0;
        }))).then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String s = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            class_2960 id = class_2960.method_12829((String)s);
            if (id == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("[SavaruInv] Invalid id: " + s)));
                return 0;
            }
            if (RulesManager.clearItemRule(id)) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] Cleared " + String.valueOf(id))), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[SavaruInv] Nothing to clear."));
            return 0;
        })))).then(class_2170.method_9247((String)"tag").then(class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String s = StringArgumentType.getString((CommandContext)ctx, (String)"tag");
            String norm = SavaruInvCommands.normalizeTag(s);
            if (norm == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("[SavaruInv] Invalid tag: " + s)));
                return 0;
            }
            if (RulesManager.clearTagRule(norm)) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[SavaruInv] Cleared #" + norm)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[SavaruInv] Nothing to clear."));
            return 0;
        })))));
    }

    private static class_2960 idOf(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return null;
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909());
    }

    private static String normalizeTag(String s) {
        class_2960 id;
        if (s == null) {
            return null;
        }
        String t = s.trim();
        if (t.startsWith("#")) {
            t = t.substring(1);
        }
        return (id = class_2960.method_12829((String)t)) == null ? null : id.toString();
    }
}

