/*
 * Decompiled with CFR 0.152.
 */
package com.savaru.inv.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.savaru.inv.SavaruInvMod;
import com.savaru.inv.config.Rules;
import com.savaru.inv.grid.Footprint;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class RulesManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<class_2960, Footprint> ITEM_RULES = new HashMap<class_2960, Footprint>();
    private static final List<TagRule> TAG_RULES = new ArrayList<TagRule>();
    private static Footprint DEFAULT = new Footprint(1, 1);
    private static Rules CURRENT = null;

    public static synchronized void ensureLoaded() {
        if (CURRENT != null) {
            return;
        }
        try {
            RulesManager.loadIfExists();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (CURRENT == null) {
            CURRENT = Rules.defaults();
        }
    }

    private static Path configPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("savaru_inv").resolve("rules.json");
    }

    private static void loadIfExists() throws IOException {
        Path p = RulesManager.configPath();
        if (!Files.exists(p, new LinkOption[0])) {
            return;
        }
        String json = Files.readString(p, StandardCharsets.UTF_8);
        if (json == null || json.isBlank()) {
            return;
        }
        Rules parsed = (Rules)GSON.fromJson(json, Rules.class);
        if (parsed == null) {
            return;
        }
        if (parsed.defaultRule == null) {
            parsed.defaultRule = new Rules.DefaultRule();
        }
        if (parsed.rules == null) {
            parsed.rules = new ArrayList<Rules.Rule>();
        }
        CURRENT = parsed;
        RulesManager.rebuildCaches(parsed);
    }

    public static void initAndLoad() {
        try {
            RulesManager.ensureDefaultFile();
            RulesManager.reload();
        }
        catch (Exception e) {
            SavaruInvMod.LOGGER.error("Failed to init rules.json", (Throwable)e);
        }
    }

    private static void ensureDefaultFile() throws IOException {
        Path p = RulesManager.configPath();
        Files.createDirectories(p.getParent(), new FileAttribute[0]);
        if (Files.exists(p, new LinkOption[0])) {
            return;
        }
        String defaultJson = "{\n  \"version\": 1,\n  \"rules\": [\n    { \"tag\": \"#minecraft:swords\", \"size\": [1, 2] },\n    { \"tag\": \"#minecraft:pickaxes\", \"size\": [1, 2] },\n    { \"tag\": \"#minecraft:axes\", \"size\": [1, 2] },\n    { \"tag\": \"#minecraft:shovels\", \"size\": [1, 2] },\n    { \"tag\": \"#minecraft:hoes\", \"size\": [1, 2] },\n    { \"item\": \"minecraft:shield\", \"size\": [2, 2] },\n    { \"tag\": \"#minecraft:beds\", \"size\": [2, 3] },\n    { \"tag\": \"#minecraft:doors\", \"size\": [1, 2] }\n  ],\n  \"defaultRule\": { \"size\": [1, 1] }\n}\n";
        Files.writeString(p, (CharSequence)defaultJson, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void reload() throws IOException {
        Path p = RulesManager.configPath();
        String json = Files.readString(p, StandardCharsets.UTF_8);
        Rules parsed = (Rules)GSON.fromJson(json, Rules.class);
        if (parsed == null) {
            parsed = new Rules();
        }
        if (parsed.rules == null) {
            parsed.rules = new ArrayList<Rules.Rule>();
        }
        if (parsed.defaultRule == null) {
            parsed.defaultRule = new Rules.DefaultRule();
        }
        CURRENT = parsed;
        RulesManager.rebuildCaches(parsed);
        SavaruInvMod.LOGGER.info("Rules loaded. itemRules={}, tagRules={}, default={}x{}", new Object[]{ITEM_RULES.size(), TAG_RULES.size(), DEFAULT.w(), DEFAULT.h()});
    }

    private static void rebuildCaches(Rules parsed) {
        int[] nArray;
        ITEM_RULES.clear();
        TAG_RULES.clear();
        if (parsed.defaultRule != null) {
            nArray = parsed.defaultRule.size;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 1;
        }
        DEFAULT = Rules.toFootprint(nArray);
        if (parsed.rules != null) {
            for (Rules.Rule r : parsed.rules) {
                class_2960 id;
                Footprint fp = Rules.toFootprint(r.size);
                if (r.item != null && !r.item.isBlank()) {
                    class_2960 id2 = class_2960.method_12829((String)r.item.trim());
                    if (id2 == null) continue;
                    ITEM_RULES.put(id2, fp);
                    continue;
                }
                if (r.tag == null || r.tag.isBlank()) continue;
                String t = r.tag.trim();
                if (t.startsWith("#")) {
                    t = t.substring(1);
                }
                if ((id = class_2960.method_12829((String)t)) == null) continue;
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
                TAG_RULES.add(new TagRule((class_6862<class_1792>)tagKey, fp, "#" + String.valueOf(id)));
            }
        }
    }

    private static void saveCurrent() throws IOException {
        if (CURRENT == null) {
            return;
        }
        Path p = RulesManager.configPath();
        Files.createDirectories(p.getParent(), new FileAttribute[0]);
        Files.writeString(p, (CharSequence)GSON.toJson((Object)CURRENT), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static Footprint getFootprint(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return new Footprint(1, 1);
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        Footprint fp = ITEM_RULES.get(id);
        if (fp != null) {
            return fp;
        }
        for (TagRule tr : TAG_RULES) {
            if (!stack.method_31573(tr.tag)) continue;
            return tr.fp;
        }
        return DEFAULT;
    }

    public static Footprint getFootprintByItemId(class_2960 id) {
        if (id == null) {
            return DEFAULT;
        }
        Footprint fp = ITEM_RULES.get(id);
        return fp != null ? fp : DEFAULT;
    }

    public static Footprint getFootprintByTagString(String tagWithoutHash) {
        if (tagWithoutHash == null) {
            return DEFAULT;
        }
        String want = "#" + tagWithoutHash;
        for (TagRule tr : TAG_RULES) {
            if (!tr.originalTagString.equals(want)) continue;
            return tr.fp;
        }
        return DEFAULT;
    }

    public static boolean setItemRule(class_2960 id, int w, int h) {
        try {
            if (CURRENT == null) {
                RulesManager.reload();
            }
            RulesManager.upsertRuleItem(id.toString(), w, h);
            RulesManager.saveCurrent();
            RulesManager.rebuildCaches(CURRENT);
            return true;
        }
        catch (Exception e) {
            SavaruInvMod.LOGGER.error("setItemRule failed", (Throwable)e);
            return false;
        }
    }

    public static boolean setTagRule(String tagWithoutHash, int w, int h) {
        try {
            if (CURRENT == null) {
                RulesManager.reload();
            }
            String t = "#" + tagWithoutHash;
            RulesManager.upsertRuleTag(t, w, h);
            RulesManager.saveCurrent();
            RulesManager.rebuildCaches(CURRENT);
            return true;
        }
        catch (Exception e) {
            SavaruInvMod.LOGGER.error("setTagRule failed", (Throwable)e);
            return false;
        }
    }

    public static boolean clearItemRule(class_2960 id) {
        try {
            boolean removed;
            if (CURRENT == null) {
                RulesManager.reload();
            }
            if (!(removed = RulesManager.removeRule(r -> r.item != null && r.item.equals(id.toString())))) {
                return false;
            }
            RulesManager.saveCurrent();
            RulesManager.rebuildCaches(CURRENT);
            return true;
        }
        catch (Exception e) {
            SavaruInvMod.LOGGER.error("clearItemRule failed", (Throwable)e);
            return false;
        }
    }

    public static boolean clearTagRule(String tagWithoutHash) {
        try {
            String t;
            boolean removed;
            if (CURRENT == null) {
                RulesManager.reload();
            }
            if (!(removed = RulesManager.removeRule(arg_0 -> RulesManager.lambda$clearTagRule$1(t = "#" + tagWithoutHash, arg_0)))) {
                return false;
            }
            RulesManager.saveCurrent();
            RulesManager.rebuildCaches(CURRENT);
            return true;
        }
        catch (Exception e) {
            SavaruInvMod.LOGGER.error("clearTagRule failed", (Throwable)e);
            return false;
        }
    }

    private static void upsertRuleItem(String itemId, int w, int h) {
        Objects.requireNonNull(CURRENT);
        for (Rules.Rule r : RulesManager.CURRENT.rules) {
            if (r.item == null || !r.item.equals(itemId)) continue;
            r.size = new int[]{w, h};
            r.tag = null;
            return;
        }
        Rules.Rule nr = new Rules.Rule();
        nr.item = itemId;
        nr.size = new int[]{w, h};
        RulesManager.CURRENT.rules.add(nr);
    }

    private static void upsertRuleTag(String tagWithHash, int w, int h) {
        Objects.requireNonNull(CURRENT);
        for (Rules.Rule r : RulesManager.CURRENT.rules) {
            if (r.tag == null || !r.tag.equals(tagWithHash)) continue;
            r.size = new int[]{w, h};
            r.item = null;
            return;
        }
        Rules.Rule nr = new Rules.Rule();
        nr.tag = tagWithHash;
        nr.size = new int[]{w, h};
        RulesManager.CURRENT.rules.add(nr);
    }

    private static boolean removeRule(Predicate<Rules.Rule> pred) {
        Objects.requireNonNull(CURRENT);
        if (RulesManager.CURRENT.rules == null) {
            RulesManager.CURRENT.rules = new ArrayList<Rules.Rule>();
        }
        return RulesManager.CURRENT.rules.removeIf(pred);
    }

    public static List<String> listRules() {
        RulesManager.ensureLoaded();
        Objects.requireNonNull(CURRENT);
        if (RulesManager.CURRENT.rules == null || RulesManager.CURRENT.rules.isEmpty()) {
            return List.of();
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Rules.Rule r : RulesManager.CURRENT.rules) {
            String key;
            if (r == null || r.size == null || r.size.length < 2) continue;
            int w = r.size[0];
            int h = r.size[1];
            String string = key = r.item != null ? r.item : r.tag;
            if (key == null) continue;
            out.add(key + " -> " + w + "x" + h);
        }
        out.sort(String.CASE_INSENSITIVE_ORDER);
        return out;
    }

    private static /* synthetic */ boolean lambda$clearTagRule$1(String t, Rules.Rule r) {
        return r.tag != null && r.tag.equals(t);
    }

    private record TagRule(class_6862<class_1792> tag, Footprint fp, String originalTagString) {
    }
}

