/*
 * Decompiled with CFR 0.152.
 */
package com.savaru.inv.grid;

import com.savaru.inv.config.RulesManager;
import com.savaru.inv.grid.AnchorInfo;
import com.savaru.inv.grid.Footprint;
import com.savaru.inv.grid.OccupancyGrid;
import com.savaru.inv.grid.PlayerInvGridMap;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

public final class GridState {
    public final OccupancyGrid grid = new OccupancyGrid(9, 3);
    private boolean dirty = true;

    public int anchorOfInvIndex(int invIndex) {
        int y;
        if (!PlayerInvGridMap.isMain(invIndex)) {
            return invIndex;
        }
        int x = PlayerInvGridMap.toX(invIndex);
        AnchorInfo info = this.grid.get(x, y = PlayerInvGridMap.toY(invIndex));
        return info == null ? invIndex : info.anchorInvIndex();
    }

    public boolean isPlaceholder(int invIndex) {
        int anchor = this.anchorOfInvIndex(invIndex);
        return PlayerInvGridMap.isMain(invIndex) && anchor != invIndex;
    }

    public void clearAnchor(int anchorInvIndex) {
        if (!PlayerInvGridMap.isMain(anchorInvIndex)) {
            return;
        }
        this.grid.clearAnchor(anchorInvIndex);
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void ensureFresh(class_1661 inv) {
        if (this.dirty) {
            this.rebuildFromInventory(inv);
        }
    }

    public boolean canPlaceAtAnchor(int anchorInvIndex, Footprint fp) {
        if (!PlayerInvGridMap.isMain(anchorInvIndex)) {
            return true;
        }
        int x = PlayerInvGridMap.toX(anchorInvIndex);
        int y = PlayerInvGridMap.toY(anchorInvIndex);
        return this.grid.rectFitsAndIsEmptyExceptAnchor(x, y, fp.w(), fp.h(), anchorInvIndex);
    }

    public boolean placeAtAnchor(int anchorInvIndex, class_1799 stack) {
        int y;
        if (!PlayerInvGridMap.isMain(anchorInvIndex)) {
            return true;
        }
        this.clearAnchor(anchorInvIndex);
        if (stack == null || stack.method_7960()) {
            return true;
        }
        Footprint fp = RulesManager.getFootprint(stack);
        int x = PlayerInvGridMap.toX(anchorInvIndex);
        if (!this.grid.rectFitsAndIsEmpty(x, y = PlayerInvGridMap.toY(anchorInvIndex), fp.w(), fp.h())) {
            return false;
        }
        this.grid.occupyRect(x, y, fp.w(), fp.h(), anchorInvIndex, fp);
        return true;
    }

    public void clearAll() {
        this.grid.clearAll();
    }

    public void rebuildFromInventory(class_1661 inv) {
        this.grid.clearAll();
        for (int invIndex = 9; invIndex <= 35; ++invIndex) {
            class_1799 stack = inv.method_5438(invIndex);
            if (stack == null || stack.method_7960()) continue;
            Footprint fp = RulesManager.getFootprint(stack);
            int x = PlayerInvGridMap.toX(invIndex);
            int y = PlayerInvGridMap.toY(invIndex);
            if (x + fp.w() > 9 || y + fp.h() > 3) {
                fp = new Footprint(1, 1);
            }
            if (!this.grid.rectFitsAndIsEmpty(x, y, fp.w(), fp.h())) {
                if (!this.grid.rectFitsAndIsEmpty(x, y, 1, 1)) continue;
                this.grid.occupyRect(x, y, 1, 1, invIndex, new Footprint(1, 1));
                continue;
            }
            this.grid.occupyRect(x, y, fp.w(), fp.h(), invIndex, fp);
        }
        this.dirty = false;
    }
}

