/*
 * Decompiled with CFR 0.152.
 */
package com.savaru.inv.grid;

import com.savaru.inv.grid.AnchorInfo;
import com.savaru.inv.grid.Footprint;
import java.util.Arrays;

public final class OccupancyGrid {
    public final int width;
    public final int height;
    private final AnchorInfo[] cell;

    public OccupancyGrid(int width, int height) {
        this.width = width;
        this.height = height;
        this.cell = new AnchorInfo[width * height];
    }

    public void clearAll() {
        Arrays.fill(this.cell, null);
    }

    private int idx(int x, int y) {
        return x + y * this.width;
    }

    public boolean inBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public AnchorInfo get(int x, int y) {
        return this.cell[this.idx(x, y)];
    }

    public void set(int x, int y, AnchorInfo info) {
        this.cell[this.idx((int)x, (int)y)] = info;
    }

    public void clearAnchor(int anchorInvIndex) {
        for (int i = 0; i < this.cell.length; ++i) {
            AnchorInfo info = this.cell[i];
            if (info == null || info.anchorInvIndex() != anchorInvIndex) continue;
            this.cell[i] = null;
        }
    }

    public boolean rectFitsAndIsEmpty(int x, int y, int w, int h) {
        if (!this.inBounds(x, y) || !this.inBounds(x + w - 1, y + h - 1)) {
            return false;
        }
        for (int dy = 0; dy < h; ++dy) {
            for (int dx = 0; dx < w; ++dx) {
                if (this.get(x + dx, y + dy) == null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean rectFitsAndIsEmptyExceptAnchor(int x, int y, int w, int h, int exceptAnchorInvIndex) {
        if (!this.inBounds(x, y) || !this.inBounds(x + w - 1, y + h - 1)) {
            return false;
        }
        for (int dy = 0; dy < h; ++dy) {
            for (int dx = 0; dx < w; ++dx) {
                AnchorInfo a = this.get(x + dx, y + dy);
                if (a == null || a.anchorInvIndex() == exceptAnchorInvIndex) continue;
                return false;
            }
        }
        return true;
    }

    public void occupyRect(int x, int y, int w, int h, int anchorInvIndex, Footprint fp) {
        AnchorInfo info = new AnchorInfo(anchorInvIndex, fp);
        for (int dy = 0; dy < h; ++dy) {
            for (int dx = 0; dx < w; ++dx) {
                this.set(x + dx, y + dy, info);
            }
        }
    }
}

