/*
 * Decompiled with CFR 0.152.
 */
package com.savaru.inv.mixin;

import com.savaru.inv.api.PlayerInventoryStateAccess;
import com.savaru.inv.config.RulesManager;
import com.savaru.inv.grid.Footprint;
import com.savaru.inv.grid.GridState;
import com.savaru.inv.grid.PlayerInvGridMap;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5251;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class HandledScreenMixin<T extends class_1703> {
    @Shadow
    @Final
    protected T field_2797;
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;

    private boolean savaru$isCreativeInventoryScreen() {
        if (this instanceof class_481) {
            return true;
        }
        class_310 mc = class_310.method_1551();
        return mc != null && mc.field_1724 != null && mc.field_1724.method_31549().field_7477 && this.field_2797 instanceof class_1723;
    }

    private static int savaru$outlineColorFor(class_1799 stack) {
        Integer rgb;
        class_5251 tc = stack.method_7964().method_10866().method_10973();
        Integer n = rgb = tc != null ? Integer.valueOf(tc.method_27716()) : null;
        if (rgb == null) {
            Integer v;
            class_124 f = stack.method_7932().method_58413();
            Integer n2 = v = f != null ? f.method_532() : null;
            if (v != null) {
                rgb = v;
            }
        }
        if (rgb == null) {
            rgb = 0;
        }
        return 0xCC000000 | rgb & 0xFFFFFF;
    }

    @Inject(method={"onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V"}, at={@At(value="HEAD")}, require=0)
    private void savaru$preMouseClickRebuild(class_1735 clicked, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        if (this.savaru$isCreativeInventoryScreen()) {
            return;
        }
        if (clicked == null) {
            return;
        }
        class_1263 class_12632 = clicked.field_7871;
        if (!(class_12632 instanceof class_1661)) {
            return;
        }
        class_1661 pi = (class_1661)class_12632;
        GridState st = ((PlayerInventoryStateAccess)pi).savaru$getGridState();
        st.ensureFresh(pi);
    }

    @Inject(method={"onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V"}, at={@At(value="TAIL")}, require=0)
    private void savaru$postMouseClickDirty(class_1735 clicked, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        if (this.savaru$isCreativeInventoryScreen()) {
            return;
        }
        if (clicked == null) {
            return;
        }
        class_1263 class_12632 = clicked.field_7871;
        if (!(class_12632 instanceof class_1661)) {
            return;
        }
        class_1661 pi = (class_1661)class_12632;
        GridState st = ((PlayerInventoryStateAccess)pi).savaru$getGridState();
        st.markDirty();
        st.rebuildFromInventory(pi);
    }

    @Shadow
    protected abstract class_1735 method_2386(double var1, double var3);

    @Inject(method={"getSlotAt(DD)Lnet/minecraft/screen/slot/Slot;"}, at={@At(value="RETURN")}, cancellable=true, require=0)
    private void savaru$getSlotAt(double x, double y, CallbackInfoReturnable<class_1735> cir) {
        if (this.savaru$isCreativeInventoryScreen()) {
            return;
        }
        if (!this.field_2797.method_34255().method_7960()) {
            return;
        }
        class_1735 s = (class_1735)cir.getReturnValue();
        if (s == null) {
            return;
        }
        class_1263 class_12632 = s.field_7871;
        if (!(class_12632 instanceof class_1661)) {
            return;
        }
        class_1661 pi = (class_1661)class_12632;
        if (!PlayerInvGridMap.isMain(s.method_34266())) {
            return;
        }
        GridState st = ((PlayerInventoryStateAccess)pi).savaru$getGridState();
        st.ensureFresh(pi);
        int invIndex = s.method_34266();
        int anchor = st.anchorOfInvIndex(invIndex);
        if (anchor == invIndex) {
            return;
        }
        class_1735 anchorSlot = this.savaru$findPlayerInvSlot(pi, anchor);
        if (anchorSlot != null) {
            cir.setReturnValue((Object)anchorSlot);
        }
    }

    private class_1735 savaru$findPlayerInvSlot(class_1661 pi, int invIndex) {
        for (class_1735 slot : ((class_1703)this.field_2797).field_7761) {
            if (slot.field_7871 != pi || slot.method_34266() != invIndex) continue;
            return slot;
        }
        return null;
    }

    @Inject(method={"onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void savaru$onMouseClick(class_1735 clicked, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        if (this.savaru$isCreativeInventoryScreen()) {
            return;
        }
        if (clicked == null) {
            return;
        }
        class_1263 class_12632 = clicked.field_7871;
        if (!(class_12632 instanceof class_1661)) {
            return;
        }
        class_1661 pi = (class_1661)class_12632;
        int invIndex = clicked.method_34266();
        boolean isHotbar = invIndex >= 0 && invIndex <= 8;
        boolean isMain = PlayerInvGridMap.isMain(invIndex);
        if (!isHotbar && !isMain) {
            return;
        }
        GridState st = ((PlayerInventoryStateAccess)pi).savaru$getGridState();
        st.ensureFresh(pi);
        int anchor = st.anchorOfInvIndex(invIndex);
        if (anchor != invIndex) {
            ci.cancel();
            return;
        }
        if (actionType != class_1713.field_7790) {
            return;
        }
        class_1799 cursor = this.field_2797.method_34255();
        if (cursor == null || cursor.method_7960()) {
            return;
        }
        Footprint fp = RulesManager.getFootprint(cursor);
        if (isHotbar && (fp.w() != 1 || fp.h() != 1)) {
            ci.cancel();
            return;
        }
        if (isMain) {
            int x = PlayerInvGridMap.toX(anchor);
            int y = PlayerInvGridMap.toY(anchor);
            if (x + fp.w() > 9 || y + fp.h() > 3) {
                ci.cancel();
                return;
            }
        }
        if (!st.canPlaceAtAnchor(anchor, fp)) {
            ci.cancel();
        }
    }

    @Inject(method={"drawSlot(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/screen/slot/Slot;)V"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void savaru$drawSlot(class_332 context, class_1735 slot, CallbackInfo ci) {
        if (this.savaru$isCreativeInventoryScreen()) {
            return;
        }
        if (slot == null) {
            return;
        }
        class_1263 class_12632 = slot.field_7871;
        if (!(class_12632 instanceof class_1661)) {
            return;
        }
        class_1661 pi = (class_1661)class_12632;
        int invIndex = slot.method_34266();
        boolean isMain = PlayerInvGridMap.isMain(invIndex);
        if (!isMain) {
            return;
        }
        GridState st = ((PlayerInventoryStateAccess)pi).savaru$getGridState();
        st.ensureFresh(pi);
        int anchor = st.anchorOfInvIndex(invIndex);
        if (anchor != invIndex) {
            ci.cancel();
            return;
        }
        class_1799 stack = slot.method_7677();
        if (stack == null || stack.method_7960()) {
            return;
        }
        Footprint fp = RulesManager.getFootprint(stack);
        if (fp.w() == 1 && fp.h() == 1) {
            return;
        }
        int baseX = slot.field_7873;
        int baseY = slot.field_7872;
        int areaW = fp.w() * 18 - 2;
        int areaH = fp.h() * 18 - 2;
        int x1 = baseX - 1;
        int y1 = baseY - 1;
        int x2 = x1 + areaW;
        int y2 = y1 + areaH;
        int border = HandledScreenMixin.savaru$outlineColorFor(stack);
        context.method_25294(x1 + 1, y1 + 1, x2 - 1, y2 - 1, 0x44000000);
        context.method_25294(x1, y1, x2, y1 + 1, border);
        context.method_25294(x1, y2 - 1, x2, y2, border);
        context.method_25294(x1, y1, x1 + 1, y2, border);
        context.method_25294(x2 - 1, y1, x2, y2, border);
        float maxScaleX = (float)(areaW - 2) / 16.0f;
        float maxScaleY = (float)(areaH - 2) / 16.0f;
        float scale = Math.min(1.0f, Math.min(maxScaleX, maxScaleY));
        if (scale <= 0.01f) {
            scale = 1.0f;
        }
        int drawW = Math.round(16.0f * scale);
        int drawH = Math.round(16.0f * scale);
        int cx = x1 + (areaW - drawW) / 2;
        int cy = y1 + (areaH - drawH) / 2;
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)cx, (float)cy, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        context.method_51427(stack, 0, 0);
        context.method_51448().method_22909();
        context.method_51431(class_310.method_1551().field_1772, stack, cx, cy);
        ci.cancel();
    }

    @Inject(method={"onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V"}, at={@At(value="TAIL")}, require=0)
    private void savaru$afterMouseClickRebuild(class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        if (slot == null) {
            return;
        }
        if (this.savaru$isCreativeInventoryScreen()) {
            return;
        }
        class_1263 class_12632 = slot.field_7871;
        if (!(class_12632 instanceof class_1661)) {
            return;
        }
        class_1661 pi = (class_1661)class_12632;
        int invIndex = slot.method_34266();
        if (!PlayerInvGridMap.isMain(invIndex)) {
            return;
        }
        GridState st = ((PlayerInventoryStateAccess)pi).savaru$getGridState();
        st.rebuildFromInventory(pi);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")}, require=0)
    private void savaru$renderCursorPreview(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_1735 anchorSlot;
        if (this.savaru$isCreativeInventoryScreen()) {
            return;
        }
        if (this.field_2797 == null) {
            return;
        }
        class_1799 cursor = this.field_2797.method_34255();
        if (cursor == null || cursor.method_7960()) {
            return;
        }
        class_1735 hovered = this.method_2386(mouseX, mouseY);
        if (hovered == null) {
            return;
        }
        class_1263 class_12632 = hovered.field_7871;
        if (!(class_12632 instanceof class_1661)) {
            return;
        }
        class_1661 pi = (class_1661)class_12632;
        int invIndex = hovered.method_34266();
        if (!PlayerInvGridMap.isMain(invIndex)) {
            return;
        }
        GridState st = ((PlayerInventoryStateAccess)pi).savaru$getGridState();
        Footprint fp = RulesManager.getFootprint(cursor);
        if (fp == null) {
            return;
        }
        if (fp.w() <= 1 && fp.h() <= 1) {
            return;
        }
        int anchor = st.anchorOfInvIndex(invIndex);
        if (anchor != invIndex && (anchorSlot = this.field_2797.method_7611(anchor)) != null) {
            hovered = anchorSlot;
        }
        int CELL = 18;
        int x0 = this.field_2776 + hovered.field_7873 - 1;
        int y0 = this.field_2800 + hovered.field_7872 - 1;
        int w = fp.w();
        int h = fp.h();
        int fill = 0x22FFFFFF;
        int border = 0x66FFFFFF;
        for (int dy = 0; dy < h; ++dy) {
            for (int dx = 0; dx < w; ++dx) {
                int x1 = x0 + dx * 18;
                int y1 = y0 + dy * 18;
                context.method_25294(x1, y1, x1 + 18, y1 + 18, fill);
                context.method_25294(x1, y1, x1 + 18, y1 + 1, border);
                context.method_25294(x1, y1 + 18 - 1, x1 + 18, y1 + 18, border);
                context.method_25294(x1, y1, x1 + 1, y1 + 18, border);
                context.method_25294(x1 + 18 - 1, y1, x1 + 18, y1 + 18, border);
            }
        }
    }
}

