/*
 * Decompiled with CFR 0.152.
 */
package dev.duels.projectilepreview.client.projectile;

import dev.duels.projectilepreview.client.projectile.StartPosTuning;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1835;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

@Environment(value=EnvType.CLIENT)
public final class AimProfiles {
    private static final Set<class_1792> POTIONS = Set.of(class_1802.field_8436, class_1802.field_8150);
    private static final boolean AIM_TO_CROSSHAIR = true;
    private static final double AIM_MAX_DIST = 128.0;
    private static final double TRIDENT_RAISE_PER_TICK = 0.006;
    private static final double TRIDENT_MAX_RAISE = 0.04;
    private static final double TRIDENT_FORWARD_PER_TICK = 0.003;
    private static final double TRIDENT_MAX_FORWARD = 0.02;

    private AimProfiles() {
    }

    public static Profile match(class_1657 player, class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1753) {
            if (!player.method_6115()) {
                return null;
            }
            return Profiles.BOW;
        }
        if (item instanceof class_1764) {
            if (!class_1764.method_7781((class_1799)stack)) {
                return null;
            }
            return Profiles.CROSSBOW;
        }
        if (item instanceof class_1835) {
            if (!player.method_6115()) {
                return null;
            }
            return Profiles.TRIDENT;
        }
        if (item == class_1802.field_49098) {
            return Profiles.WIND;
        }
        if (item == class_1802.field_8287) {
            return Profiles.XP_BOTTLE;
        }
        if (POTIONS.contains(item)) {
            return Profiles.POTION;
        }
        if (item == class_1802.field_8634) {
            return Profiles.PEARL;
        }
        if (item == class_1802.field_8543 || item == class_1802.field_8803) {
            return Profiles.SNOW_EGG;
        }
        return null;
    }

    private static class_243 handTipPos(class_1657 p, float td, double f, double s, double u) {
        boolean mainArmRight;
        class_243 eye = p.method_5836(td);
        class_243 forward = p.method_5828(td).method_1029();
        double yaw = Math.toRadians(p.method_5705(td));
        class_243 fwdYaw = new class_243(-Math.sin(yaw), 0.0, Math.cos(yaw)).method_1029();
        class_243 right = new class_243(0.0, 1.0, 0.0).method_1036(fwdYaw).method_1029();
        class_243 up = forward.method_1036(right).method_1029();
        class_1268 active = p.method_6115() ? p.method_6058() : class_1268.field_5808;
        boolean bl = mainArmRight = p.method_6068() == class_1306.field_6183;
        boolean rightSide = active == class_1268.field_5808 ? mainArmRight : !mainArmRight;
        double sideSign = rightSide ? 1.0 : -1.0;
        return eye.method_1019(forward.method_1021(f)).method_1019(right.method_1021(s * sideSign)).method_1019(up.method_1021(u));
    }

    private static class_243 rotateYaw(class_243 v, double deg) {
        double r = Math.toRadians(deg);
        return new class_243(v.field_1352 * Math.cos(r) - v.field_1350 * Math.sin(r), v.field_1351, v.field_1352 * Math.sin(r) + v.field_1350 * Math.cos(r));
    }

    private static int multishotLevel(class_1657 p, class_1799 stack) {
        class_5455 lookup = p.method_56673();
        class_2378 enchWrapper = lookup.method_30530(class_7924.field_41265);
        class_6880.class_6883 entry = enchWrapper.method_46747(class_1893.field_9108);
        return class_1890.method_8225((class_6880)entry, (class_1799)stack);
    }

    private static class_243 aimPoint(class_1657 p, float td, double maxDist) {
        class_243 dir;
        class_243 end;
        class_243 eye;
        class_1937 world = p.method_37908();
        class_3965 hit = world.method_17742(new class_3959(eye = p.method_5836(td), end = eye.method_1019((dir = p.method_5828(td).method_1029()).method_1021(maxDist)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)p));
        return hit.method_17783() == class_239.class_240.field_1333 ? end : hit.method_17784();
    }

    private static class_243 dirToCrosshair(class_1657 p, float td, class_243 startPos, double maxDist) {
        class_243 target = AimProfiles.aimPoint(p, td, maxDist);
        class_243 d = target.method_1020(startPos);
        double len = d.method_1033();
        if (len < 1.0E-6) {
            return p.method_5828(td).method_1029();
        }
        return d.method_1021(1.0 / len);
    }

    private static class_243 dirWithPitchOffset(class_1657 p, float td, float pitchOffsetDeg) {
        double z;
        double y;
        float yaw = p.method_5705(td);
        float pitch = p.method_5695(td) + pitchOffsetDeg;
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        double x = -Math.sin(yawRad) * Math.cos(pitchRad);
        class_243 v = new class_243(x, y = -Math.sin(pitchRad), z = Math.cos(yawRad) * Math.cos(pitchRad));
        double len = v.method_1033();
        return len < 1.0E-6 ? p.method_5828(td).method_1029() : v.method_1021(1.0 / len);
    }

    private static double tridentChargeTicks(class_1657 p, class_1799 trident, float td) {
        int used = trident.method_7935((class_1309)p) - p.method_6014();
        return (float)used + td;
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Profiles {
        static final Profile BOW = new Profile(){

            @Override
            public double drag() {
                return 0.99;
            }

            @Override
            public double gravity() {
                return 0.05;
            }

            @Override
            public class_243 startPos(class_1657 p, float td) {
                return AimProfiles.handTipPos(p, td, StartPosTuning.BOW_F, StartPosTuning.BOW_S, StartPosTuning.BOW_U);
            }

            @Override
            public List<class_243> startVels(class_1657 p, class_1799 s, float td) {
                int used = s.method_7935((class_1309)p) - p.method_6014();
                float pull = class_1753.method_7722((int)used);
                if (pull < 0.05f) {
                    return List.of();
                }
                class_243 start = this.startPos(p, td);
                class_243 dir = AimProfiles.dirToCrosshair(p, td, start, 128.0);
                return List.of(dir.method_1021(3.0 * (double)pull).method_1019(p.method_18798()));
            }
        };
        static final Profile CROSSBOW = new Profile(){

            @Override
            public double drag() {
                return 0.99;
            }

            @Override
            public double gravity() {
                return 0.05;
            }

            @Override
            public class_243 startPos(class_1657 p, float td) {
                return AimProfiles.handTipPos(p, td, StartPosTuning.CROSS_F, StartPosTuning.CROSS_S, StartPosTuning.CROSS_U);
            }

            @Override
            public List<class_243> startVels(class_1657 p, class_1799 s, float td) {
                class_243 start = this.startPos(p, td);
                class_243 dir = AimProfiles.dirToCrosshair(p, td, start, 128.0);
                class_243 base = dir.method_1021(3.15).method_1019(p.method_18798());
                int ms = AimProfiles.multishotLevel(p, s);
                if (ms > 0) {
                    return List.of(AimProfiles.rotateYaw(base, -10.0), base, AimProfiles.rotateYaw(base, 10.0));
                }
                return List.of(base);
            }
        };
        static final Profile TRIDENT = new Profile(){

            @Override
            public double drag() {
                return 0.99;
            }

            @Override
            public double gravity() {
                return 0.05;
            }

            @Override
            public class_243 startPos(class_1657 p, float td) {
                class_243 base = AimProfiles.handTipPos(p, td, StartPosTuning.TRIDENT_F, StartPosTuning.TRIDENT_S, StartPosTuning.TRIDENT_U);
                double t = AimProfiles.tridentChargeTicks(p, p.method_6030(), td);
                class_243 forward = p.method_5828(td).method_1029();
                float yawDeg = p.method_5705(td);
                double yaw = Math.toRadians(yawDeg);
                class_243 right = new class_243(Math.cos(yaw), 0.0, Math.sin(yaw)).method_1029();
                class_243 up = forward.method_1036(right).method_1029();
                double raise = Math.min(0.04, t * 0.006);
                double fwd = Math.min(0.02, t * 0.003);
                return base.method_1019(up.method_1021(raise)).method_1019(forward.method_1021(fwd));
            }

            @Override
            public List<class_243> startVels(class_1657 p, class_1799 s, float td) {
                class_243 start = this.startPos(p, td);
                class_243 dir = AimProfiles.dirToCrosshair(p, td, start, 128.0);
                return List.of(dir.method_1021(3.0).method_1019(p.method_18798()));
            }
        };
        static final Profile SNOW_EGG = new Profile(){

            @Override
            public double drag() {
                return 0.99;
            }

            @Override
            public double gravity() {
                return 0.03;
            }

            @Override
            public class_243 startPos(class_1657 p, float td) {
                return AimProfiles.handTipPos(p, td, StartPosTuning.THROW_F, StartPosTuning.THROW_S, StartPosTuning.THROW_U);
            }

            @Override
            public List<class_243> startVels(class_1657 p, class_1799 s, float td) {
                class_243 start = this.startPos(p, td);
                class_243 dir = AimProfiles.dirToCrosshair(p, td, start, 128.0);
                return List.of(dir.method_1021(1.5).method_1019(p.method_18798()));
            }
        };
        static final Profile PEARL = new Profile(){

            @Override
            public double drag() {
                return 0.99;
            }

            @Override
            public double gravity() {
                return 0.03;
            }

            @Override
            public class_243 startPos(class_1657 p, float td) {
                return AimProfiles.handTipPos(p, td, StartPosTuning.THROW_F, StartPosTuning.THROW_S, StartPosTuning.THROW_U);
            }

            @Override
            public List<class_243> startVels(class_1657 p, class_1799 s, float td) {
                class_243 start = this.startPos(p, td);
                class_243 dir = AimProfiles.dirToCrosshair(p, td, start, 128.0);
                return List.of(dir.method_1021(1.5).method_1019(p.method_18798()));
            }
        };
        static final Profile XP_BOTTLE = new Profile(){

            @Override
            public double drag() {
                return 0.99;
            }

            @Override
            public double gravity() {
                return 0.07;
            }

            @Override
            public class_243 startPos(class_1657 p, float td) {
                return AimProfiles.handTipPos(p, td, StartPosTuning.THROW_F, StartPosTuning.THROW_S, StartPosTuning.THROW_U);
            }

            @Override
            public List<class_243> startVels(class_1657 p, class_1799 s, float td) {
                class_243 start = this.startPos(p, td);
                class_243 dir = AimProfiles.dirToCrosshair(p, td, start, 128.0);
                class_243 off = AimProfiles.dirWithPitchOffset(p, td, -20.0f);
                dir = dir.method_35590(off, 0.65).method_1029();
                return List.of(dir.method_1021(0.7).method_1019(p.method_18798()));
            }
        };
        static final Profile POTION = new Profile(){

            @Override
            public double drag() {
                return 0.99;
            }

            @Override
            public double gravity() {
                return 0.05;
            }

            @Override
            public class_243 startPos(class_1657 p, float td) {
                return AimProfiles.handTipPos(p, td, StartPosTuning.THROW_F, StartPosTuning.THROW_S, StartPosTuning.THROW_U);
            }

            @Override
            public List<class_243> startVels(class_1657 p, class_1799 s, float td) {
                class_243 start = this.startPos(p, td);
                class_243 dir = AimProfiles.dirToCrosshair(p, td, start, 128.0);
                class_243 off = AimProfiles.dirWithPitchOffset(p, td, -20.0f);
                dir = dir.method_35590(off, 0.65).method_1029();
                return List.of(dir.method_1021(0.5).method_1019(p.method_18798()));
            }
        };
        static final Profile WIND = new Profile(){

            @Override
            public double drag() {
                return 0.995;
            }

            @Override
            public double gravity() {
                return 0.0;
            }

            @Override
            public class_243 startPos(class_1657 p, float td) {
                return AimProfiles.handTipPos(p, td, StartPosTuning.WIND_F, StartPosTuning.WIND_S, StartPosTuning.WIND_U);
            }

            @Override
            public List<class_243> startVels(class_1657 p, class_1799 s, float td) {
                class_243 start = this.startPos(p, td);
                class_243 dir = AimProfiles.dirToCrosshair(p, td, start, 128.0);
                return List.of(dir.method_1021(1.6).method_1019(p.method_18798()));
            }
        };

        private Profiles() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Profile {
        default public int steps() {
            return 60;
        }

        default public double stepTime() {
            return 1.0;
        }

        public double drag();

        public double gravity();

        public class_243 startPos(class_1657 var1, float var2);

        public List<class_243> startVels(class_1657 var1, class_1799 var2, float var3);
    }
}

