/*
 * Decompiled with CFR 0.152.
 */
package dev.duels.projectilepreview.client.projectile;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.duels.projectilepreview.client.projectile.TrajectorySim;
import java.lang.reflect.Method;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class RenderUtils {
    private static final float FACE_EPS = 0.0f;
    private static final double OUTLINE_PUSH = 0.01;
    private static final double HITBOX_BORDER_GROW = 0.0;

    private RenderUtils() {
    }

    public static void drawPolyline(class_4587 matrices, class_4597 consumers, List<class_243> points, class_243 camPos) {
        if (points == null || points.size() < 2) {
            return;
        }
        class_4588 vc = consumers.getBuffer(class_1921.method_23594());
        Matrix4f m = matrices.method_23760().method_23761();
        for (int i = 0; i < points.size() - 1; ++i) {
            class_243 a = points.get(i).method_1020(camPos);
            class_243 b = points.get(i + 1).method_1020(camPos);
            RenderUtils.line(vc, m, a, b, 255, 255, 255, 255);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHitOverlay(class_4587 matrices, class_4597 consumers, TrajectorySim.HitInfo hit, class_243 camPos) {
        if (hit == null) {
            return;
        }
        RenderUtils.rsCall("enableBlend");
        RenderUtils.rsCall("disableCull");
        RenderUtils.rsCall("disableDepthTest");
        RenderUtils.rsCall("depthMask", Boolean.TYPE, false);
        try {
            if (hit instanceof TrajectorySim.HitInfo.BlockHit) {
                class_238 camBox;
                class_238 worldBox;
                TrajectorySim.HitInfo.BlockHit bh = (TrajectorySim.HitInfo.BlockHit)hit;
                class_3965 bhr = bh.bhr();
                class_310 mc = class_310.method_1551();
                if (mc.field_1687 == null) {
                    return;
                }
                class_2338 pos = bhr.method_17777();
                class_2680 state = mc.field_1687.method_8320(pos);
                class_265 shape = state.method_26172((class_1922)mc.field_1687, pos, class_3726.method_16194());
                if (shape == null || shape.method_1110()) {
                    shape = class_259.method_1077();
                }
                class_243 hitPosCam = hit.pos().method_1020(camPos);
                class_238 closest = null;
                double bestD2 = Double.POSITIVE_INFINITY;
                for (class_238 local : shape.method_1090()) {
                    worldBox = local.method_989((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    camBox = worldBox.method_989(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
                    double d2 = RenderUtils.dist2PointToBox(hitPosCam, camBox);
                    if (!(d2 < bestD2)) continue;
                    bestD2 = d2;
                    closest = camBox;
                }
                for (class_238 local : shape.method_1090()) {
                    worldBox = local.method_989((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    camBox = worldBox.method_989(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
                    class_238 outlineBox = camBox.method_1014(0.01);
                    RenderUtils.drawBoxOutlineLines(matrices, consumers, outlineBox, 80, 160, 255, 255);
                }
                if (closest != null) {
                    RenderUtils.drawFaceFillQuad(matrices, consumers, closest, hitPosCam, 80, 160, 255, 80);
                }
                return;
            }
            if (hit instanceof TrajectorySim.HitInfo.EntityHit) {
                TrajectorySim.HitInfo.EntityHit eh = (TrajectorySim.HitInfo.EntityHit)hit;
                class_1297 e = eh.entity();
                class_238 bbWorld = e.method_5829().method_1014(0.1);
                class_238 bbCam = bbWorld.method_989(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
                int[] col = RenderUtils.colorForEntity(e);
                class_238 outlineBox = bbCam.method_1014(0.01);
                RenderUtils.drawBoxOutlineLines(matrices, consumers, outlineBox, col[0], col[1], col[2], 255);
                class_243 hitPosCam = hit.pos().method_1020(camPos);
                RenderUtils.drawFaceFillQuad(matrices, consumers, bbCam, hitPosCam, col[0], col[1], col[2], 80);
            }
        }
        finally {
            RenderUtils.rsCall("depthMask", Boolean.TYPE, true);
            RenderUtils.rsCall("enableDepthTest");
            RenderUtils.rsCall("enableCull");
        }
    }

    private static void drawFaceFillQuad(class_4587 matrices, class_4597 consumers, class_238 b, class_243 hitPosCam, int r, int g, int bl, int aFill) {
        class_2350 face = RenderUtils.nearestFace(b, hitPosCam);
        class_4588 vc = consumers.getBuffer(class_1921.method_49047());
        Matrix4f m = matrices.method_23760().method_23761();
        float x1 = (float)b.field_1323;
        float x2 = (float)b.field_1320;
        float y1 = (float)b.field_1322;
        float y2 = (float)b.field_1325;
        float z1 = (float)b.field_1321;
        float z2 = (float)b.field_1324;
        switch (face) {
            case field_11039: {
                float x = x1 - 0.0f;
                RenderUtils.faceTwoTrianglesDoubleSided(vc, m, x, y1, z1, x, y2, z1, x, y2, z2, x, y1, z2, r, g, bl, aFill);
                break;
            }
            case field_11034: {
                float x = x2 + 0.0f;
                RenderUtils.faceTwoTrianglesDoubleSided(vc, m, x, y1, z2, x, y2, z2, x, y2, z1, x, y1, z1, r, g, bl, aFill);
                break;
            }
            case field_11043: {
                float z = z1 - 0.0f;
                RenderUtils.faceTwoTrianglesDoubleSided(vc, m, x2, y1, z, x2, y2, z, x1, y2, z, x1, y1, z, r, g, bl, aFill);
                break;
            }
            case field_11035: {
                float z = z2 + 0.0f;
                RenderUtils.faceTwoTrianglesDoubleSided(vc, m, x1, y1, z, x1, y2, z, x2, y2, z, x2, y1, z, r, g, bl, aFill);
                break;
            }
            case field_11033: {
                float y = y1 - 0.0f;
                RenderUtils.faceTwoTrianglesDoubleSided(vc, m, x1, y, z2, x2, y, z2, x2, y, z1, x1, y, z1, r, g, bl, aFill);
                break;
            }
            case field_11036: {
                float y = y2 + 0.0f;
                RenderUtils.faceTwoTrianglesDoubleSided(vc, m, x1, y, z1, x2, y, z1, x2, y, z2, x1, y, z2, r, g, bl, aFill);
            }
        }
    }

    private static void faceTwoTrianglesDoubleSided(class_4588 vc, Matrix4f m, float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, float dx, float dy, float dz, int r, int g, int b, int a) {
        RenderUtils.v(vc, m, ax, ay, az, r, g, b, a);
        RenderUtils.v(vc, m, bx, by, bz, r, g, b, a);
        RenderUtils.v(vc, m, cx, cy, cz, r, g, b, a);
        RenderUtils.v(vc, m, ax, ay, az, r, g, b, a);
        RenderUtils.v(vc, m, cx, cy, cz, r, g, b, a);
        RenderUtils.v(vc, m, dx, dy, dz, r, g, b, a);
        RenderUtils.v(vc, m, cx, cy, cz, r, g, b, a);
        RenderUtils.v(vc, m, bx, by, bz, r, g, b, a);
        RenderUtils.v(vc, m, ax, ay, az, r, g, b, a);
        RenderUtils.v(vc, m, dx, dy, dz, r, g, b, a);
        RenderUtils.v(vc, m, cx, cy, cz, r, g, b, a);
        RenderUtils.v(vc, m, ax, ay, az, r, g, b, a);
    }

    private static void drawBoxOutlineLines(class_4587 matrices, class_4597 consumers, class_238 b, int r, int g, int bl, int a) {
        class_4588 vc = consumers.getBuffer(class_1921.method_23594());
        Matrix4f m = matrices.method_23760().method_23761();
        class_243 p000 = new class_243(b.field_1323, b.field_1322, b.field_1321);
        class_243 p001 = new class_243(b.field_1323, b.field_1322, b.field_1324);
        class_243 p010 = new class_243(b.field_1323, b.field_1325, b.field_1321);
        class_243 p011 = new class_243(b.field_1323, b.field_1325, b.field_1324);
        class_243 p100 = new class_243(b.field_1320, b.field_1322, b.field_1321);
        class_243 p101 = new class_243(b.field_1320, b.field_1322, b.field_1324);
        class_243 p110 = new class_243(b.field_1320, b.field_1325, b.field_1321);
        class_243 p111 = new class_243(b.field_1320, b.field_1325, b.field_1324);
        RenderUtils.line(vc, m, p000, p001, r, g, bl, a);
        RenderUtils.line(vc, m, p001, p101, r, g, bl, a);
        RenderUtils.line(vc, m, p101, p100, r, g, bl, a);
        RenderUtils.line(vc, m, p100, p000, r, g, bl, a);
        RenderUtils.line(vc, m, p010, p011, r, g, bl, a);
        RenderUtils.line(vc, m, p011, p111, r, g, bl, a);
        RenderUtils.line(vc, m, p111, p110, r, g, bl, a);
        RenderUtils.line(vc, m, p110, p010, r, g, bl, a);
        RenderUtils.line(vc, m, p000, p010, r, g, bl, a);
        RenderUtils.line(vc, m, p001, p011, r, g, bl, a);
        RenderUtils.line(vc, m, p100, p110, r, g, bl, a);
        RenderUtils.line(vc, m, p101, p111, r, g, bl, a);
    }

    private static void line(class_4588 vc, Matrix4f m, class_243 a, class_243 b, int r, int g, int bl, int alpha) {
        vc.method_22918(m, (float)a.field_1352, (float)a.field_1351, (float)a.field_1350).method_1336(r, g, bl, alpha).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(m, (float)b.field_1352, (float)b.field_1351, (float)b.field_1350).method_1336(r, g, bl, alpha).method_22914(0.0f, 1.0f, 0.0f);
    }

    private static class_2350 nearestFace(class_238 b, class_243 hit) {
        double dxMin = Math.abs(hit.field_1352 - b.field_1323);
        double dxMax = Math.abs(hit.field_1352 - b.field_1320);
        double dyMin = Math.abs(hit.field_1351 - b.field_1322);
        double dyMax = Math.abs(hit.field_1351 - b.field_1325);
        double dzMin = Math.abs(hit.field_1350 - b.field_1321);
        double dzMax = Math.abs(hit.field_1350 - b.field_1324);
        class_2350 best = class_2350.field_11039;
        double bestD = dxMin;
        if (dxMax < bestD) {
            bestD = dxMax;
            best = class_2350.field_11034;
        }
        if (dyMin < bestD) {
            bestD = dyMin;
            best = class_2350.field_11033;
        }
        if (dyMax < bestD) {
            bestD = dyMax;
            best = class_2350.field_11036;
        }
        if (dzMin < bestD) {
            bestD = dzMin;
            best = class_2350.field_11043;
        }
        if (dzMax < bestD) {
            bestD = dzMax;
            best = class_2350.field_11035;
        }
        return best;
    }

    private static int[] colorForEntity(class_1297 e) {
        if (e instanceof class_1657) {
            return new int[]{180, 90, 255};
        }
        if (e instanceof class_1296) {
            return new int[]{60, 255, 120};
        }
        if (e instanceof class_1588) {
            return new int[]{255, 70, 70};
        }
        return new int[]{255, 165, 60};
    }

    private static double dist2PointToBox(class_243 p, class_238 b) {
        double dx = 0.0;
        if (p.field_1352 < b.field_1323) {
            dx = b.field_1323 - p.field_1352;
        } else if (p.field_1352 > b.field_1320) {
            dx = p.field_1352 - b.field_1320;
        }
        double dy = 0.0;
        if (p.field_1351 < b.field_1322) {
            dy = b.field_1322 - p.field_1351;
        } else if (p.field_1351 > b.field_1325) {
            dy = p.field_1351 - b.field_1325;
        }
        double dz = 0.0;
        if (p.field_1350 < b.field_1321) {
            dz = b.field_1321 - p.field_1350;
        } else if (p.field_1350 > b.field_1324) {
            dz = p.field_1350 - b.field_1324;
        }
        return dx * dx + dy * dy + dz * dz;
    }

    private static void rsCall(String name, Class<?> argType, Object arg) {
        try {
            Method m = RenderSystem.class.getMethod(name, argType);
            m.invoke(null, arg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void rsCall(String name) {
        try {
            Method m = RenderSystem.class.getMethod(name, new Class[0]);
            m.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void v(class_4588 vc, Matrix4f m, float x, float y, float z, int r, int g, int b, int a) {
        vc.method_22918(m, x, y, z).method_1336(r, g, b, a);
        RenderUtils.vcEnd(vc);
    }

    private static void vcEnd(class_4588 vc) {
        try {
            Method m = vc.getClass().getMethod("next", new Class[0]);
            m.invoke((Object)vc, new Object[0]);
            return;
        }
        catch (Throwable m) {
            try {
                Method m2 = vc.getClass().getMethod("endVertex", new Class[0]);
                m2.invoke((Object)vc, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }
}

