/*
 * Decompiled with CFR 0.152.
 */
package dev.duels.projectilepreview.client.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

@Environment(value=EnvType.CLIENT)
public final class TrajectorySim {
    public static final double ENTITY_HITBOX_PAD = 0.1;

    private TrajectorySim() {
    }

    public static Result simulate(class_1297 owner, class_243 startPos, class_243 startVel, double gravity, double drag, int steps, double stepTime) {
        class_1937 world = owner.method_37908();
        if (world == null) {
            return null;
        }
        ArrayList<class_243> points = new ArrayList<class_243>(steps + 1);
        class_243 pos = startPos;
        class_243 vel = startVel;
        points.add(pos);
        HitInfo finalHit = null;
        for (int i = 0; i < steps; ++i) {
            class_243 nextPos = pos.method_1019(vel.method_1021(stepTime));
            HitInfo.EntityHit entHit = TrajectorySim.raycastEntity(owner, pos, nextPos);
            if (entHit != null) {
                points.add(entHit.pos());
                finalHit = entHit;
                break;
            }
            class_3965 hit = world.method_17742(new class_3959(pos, nextPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, owner));
            if (hit.method_17783() != class_239.class_240.field_1333) {
                class_243 hp = hit.method_17784();
                points.add(hp);
                if (!(hit instanceof class_3965)) break;
                class_3965 bhr = hit;
                class_238 hb = TrajectorySim.resolveBlockHitBox(world, bhr.method_17777(), pos, nextPos);
                finalHit = new HitInfo.BlockHit(hp, bhr, hb);
                break;
            }
            points.add(nextPos);
            vel = vel.method_1021(drag).method_1031(0.0, -gravity, 0.0);
            pos = nextPos;
        }
        return new Result(points, finalHit);
    }

    private static HitInfo.EntityHit raycastEntity(class_1297 owner, class_243 from, class_243 to) {
        class_1937 world = owner.method_37908();
        if (world == null) {
            return null;
        }
        class_238 sweep = new class_238(from, to).method_1014(0.35);
        List candidates = world.method_8333(owner, sweep, e -> e.method_5805() && e instanceof class_1309 && !e.method_7325() && e.method_5863());
        if (candidates.isEmpty()) {
            return null;
        }
        class_1297 best = null;
        class_243 bestPos = null;
        double bestDist2 = Double.MAX_VALUE;
        for (class_1297 e2 : candidates) {
            class_243 hp;
            double d2;
            class_238 bb = e2.method_5829().method_1014(0.1);
            Optional opt = bb.method_992(from, to);
            if (opt.isEmpty() || !((d2 = (hp = (class_243)opt.get()).method_1025(from)) < bestDist2)) continue;
            bestDist2 = d2;
            best = e2;
            bestPos = hp;
        }
        return best == null ? null : new HitInfo.EntityHit(bestPos, best);
    }

    private static class_238 resolveBlockHitBox(class_1937 world, class_2338 bp, class_243 from, class_243 to) {
        class_2680 state = world.method_8320(bp);
        class_265 shape = state.method_26220((class_1922)world, bp);
        List boxes = shape.method_1090();
        if (boxes.isEmpty()) {
            return new class_238(bp).method_1014(0.1);
        }
        class_238 best = null;
        double bestDist2 = Double.MAX_VALUE;
        for (class_238 local : boxes) {
            class_243 hp;
            double d2;
            class_238 wb = local.method_996(bp).method_1014(0.1);
            Optional opt = wb.method_992(from, to);
            if (opt.isEmpty() || !((d2 = (hp = (class_243)opt.get()).method_1025(from)) < bestDist2)) continue;
            bestDist2 = d2;
            best = wb;
        }
        return best != null ? best : ((class_238)boxes.get(0)).method_996(bp).method_1014(0.1);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface HitInfo {
        public class_243 pos();

        @Environment(value=EnvType.CLIENT)
        public static final class EntityHit
        implements HitInfo {
            private final class_243 pos;
            private final class_1297 entity;

            public EntityHit(class_243 pos, class_1297 entity) {
                this.pos = pos;
                this.entity = entity;
            }

            @Override
            public class_243 pos() {
                return this.pos;
            }

            public class_1297 entity() {
                return this.entity;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public static final class BlockHit
        implements HitInfo {
            private final class_243 pos;
            private final class_3965 bhr;
            private final class_238 hitBoxWorld;

            public BlockHit(class_243 pos, class_3965 bhr, class_238 hitBoxWorld) {
                this.pos = pos;
                this.bhr = bhr;
                this.hitBoxWorld = hitBoxWorld;
            }

            @Override
            public class_243 pos() {
                return this.pos;
            }

            public class_3965 bhr() {
                return this.bhr;
            }

            public class_238 hitBoxWorld() {
                return this.hitBoxWorld;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Result(List<class_243> points, HitInfo hit) {
    }
}

