/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import io.github.lordfetzi.blocks.Cushion;
import io.github.lordfetzi.entity.custom.SeatEntityFixedRotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FloorChair
extends Cushion {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static VoxelShape SHAPE_NORTH = FloorChair.makeShape_N();
    private static VoxelShape SHAPE_WEST = FloorChair.makeShape_W();
    private static VoxelShape SHAPE_EAST = FloorChair.makeShape_E();
    private static VoxelShape SHAPE_SOUTH = FloorChair.makeShape_S();

    public FloorChair(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static VoxelShape makeShape_S() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.8125, (double)0.9375, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.03125, (double)0.9375, (double)0.0625, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0625, (double)0.09375, (double)0.875, (double)0.125, (double)0.84375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_E() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.09375, (double)0.0625, (double)0.125, (double)0.84375, (double)0.125, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0625, (double)0.0625, (double)1.0, (double)0.875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.03125, (double)0.0, (double)0.0625, (double)1.0, (double)0.0625, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_W() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.15625, (double)0.0625, (double)0.125, (double)0.90625, (double)0.125, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0625, (double)0.0625, (double)0.1875, (double)0.875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0625, (double)0.96875, (double)0.0625, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_N() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0625, (double)0.15625, (double)0.875, (double)0.125, (double)0.90625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.875, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)0.0625, (double)0.96875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = SHAPE_NORTH;
                break;
            }
            case EAST: {
                returnShape = SHAPE_EAST;
                break;
            }
            case SOUTH: {
                returnShape = SHAPE_SOUTH;
                break;
            }
            case WEST: {
                returnShape = SHAPE_WEST;
            }
        }
        return returnShape;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        VoxelShape returnShape = Shapes.empty();
        switch (direction) {
            case NORTH: {
                returnShape = SHAPE_NORTH;
                break;
            }
            case EAST: {
                returnShape = SHAPE_EAST;
                break;
            }
            case SOUTH: {
                returnShape = SHAPE_SOUTH;
                break;
            }
            case WEST: {
                returnShape = SHAPE_WEST;
            }
        }
        return returnShape;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        return SeatEntityFixedRotation.create(level, pos, 0.1, player, (Direction)state.getValue((Property)FACING));
    }
}

