/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks.FramedBlocks;

import io.github.lordfetzi.blocks.ShojiWall;
import io.github.lordfetzi.blocks.SlidingDoors;
import io.github.lordfetzi.blocks.SlidingTrapdoors;
import io.github.lordfetzi.entity.custom.DoubleFramedBlockEntityBase;
import io.github.lordfetzi.entity.custom.DoubleFramedBlockEntityFactory;
import io.github.lordfetzi.property.BeamVerticalProperty;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BeamBlockFramedBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BeamVerticalProperty BEAM_VERTICAL_PROPERTY = BeamVerticalProperty.create("vertical_type");
    public final VoxelShape SHAPE = Shapes.block();

    public BeamBlockFramedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)BEAM_VERTICAL_PROPERTY, (Comparable)((Object)"none")));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH}).add(new Property[]{EAST}).add(new Property[]{SOUTH}).add(new Property[]{WEST}).add(new Property[]{UP}).add(new Property[]{DOWN}).add(new Property[]{BEAM_VERTICAL_PROPERTY});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = this.isBeam(level, pos, Direction.NORTH);
        boolean east = this.isBeam(level, pos, Direction.EAST);
        boolean south = this.isBeam(level, pos, Direction.SOUTH);
        boolean west = this.isBeam(level, pos, Direction.WEST);
        boolean up = this.isBeam(level, pos, Direction.UP);
        boolean down = this.isBeam(level, pos, Direction.DOWN);
        String verticalType = "none";
        if (up || down && !north && !east && !south && !west) {
            verticalType = this.hasBlockNeighbour(level, pos);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down))).setValue((Property)BEAM_VERTICAL_PROPERTY, (Comparable)((Object)verticalType));
    }

    private boolean isBeam(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.getBlockState(source.relative(direction));
        boolean connectable = false;
        if (state.getBlock() instanceof BeamBlockFramedBlock) {
            connectable = true;
        }
        return connectable;
    }

    private String hasBlockNeighbour(LevelAccessor level, BlockPos source) {
        String verticalType = "none";
        int matchCount = 0;
        boolean north = false;
        boolean east = false;
        boolean south = false;
        boolean west = false;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState neighbourState = level.getBlockState(source.relative(dir));
            if (neighbourState.isAir() || neighbourState.getBlock() instanceof ShojiWall || neighbourState.getBlock() instanceof SlidingDoors || neighbourState.getBlock() instanceof SlidingTrapdoors) continue;
            ++matchCount;
            switch (dir) {
                case NORTH: {
                    north = true;
                    break;
                }
                case EAST: {
                    east = true;
                    break;
                }
                case SOUTH: {
                    south = true;
                    break;
                }
                case WEST: {
                    west = true;
                }
            }
        }
        if (north && east) {
            verticalType = "corner_ne";
        } else if (east && south) {
            verticalType = "corner_se";
        } else if (south && west) {
            verticalType = "corner_sw";
        } else if (west && north) {
            verticalType = "corner_nw";
        } else if (matchCount == 1) {
            if (north) {
                verticalType = "south";
            }
            if (east) {
                verticalType = "west";
            }
            if (south) {
                verticalType = "north";
            }
            if (west) {
                verticalType = "east";
            }
        } else if (matchCount > 1) {
            verticalType = "none";
        }
        return verticalType;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item;
        ItemStack heldItem = player.getItemInHand(hand);
        if (!world.isClientSide && (item = heldItem.getItem()) instanceof BlockItem) {
            DoubleFramedBlockEntityBase framedBlockEntity;
            BlockItem blockItem = (BlockItem)item;
            if (blockItem.getBlock().arch$registryName().getNamespace().equals("fetzisasiandeco") && (blockItem.getBlock().arch$registryName().toString().contains("framed_block") || blockItem.getBlock().arch$registryName().toString().contains("framed_double_block"))) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof DoubleFramedBlockEntityBase && !(framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity).hasTexture1()) {
                framedBlockEntity.setTexture1(blockItem.getBlock().arch$registryName().toString());
                framedBlockEntity.setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
                world.playSound(null, pos, blockItem.getBlock().defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            if (blockEntity instanceof DoubleFramedBlockEntityBase && !(framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity).hasTexture2()) {
                framedBlockEntity.setTexture2(blockItem.getBlock().arch$registryName().toString());
                framedBlockEntity.setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
                world.playSound(null, pos, blockItem.getBlock().defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof DoubleFramedBlockEntityBase) {
            DoubleFramedBlockEntityBase framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity;
            if (!player.isCreative()) {
                ResourceLocation resourceLocation;
                Block textureBlock;
                String textureId2;
                ResourceLocation resourceLocation2;
                Block textureBlock2;
                String textureId1 = framedBlockEntity.getTexture1();
                if (textureId1 != null && (textureBlock2 = (Block)BuiltInRegistries.BLOCK.get(resourceLocation2 = ResourceLocation.parse((String)textureId1))) != Blocks.AIR) {
                    ItemStack dropStack = new ItemStack((ItemLike)textureBlock2);
                    BeamBlockFramedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)dropStack);
                }
                if ((textureId2 = framedBlockEntity.getTexture2()) != null && (textureBlock = (Block)BuiltInRegistries.BLOCK.get(resourceLocation = ResourceLocation.parse((String)textureId2))) != Blocks.AIR) {
                    ItemStack dropStack = new ItemStack((ItemLike)textureBlock);
                    BeamBlockFramedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)dropStack);
                }
            }
        }
        super.playerWillDestroy(world, pos, state, player);
        return state;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = world.getBlockEntity(pos)) instanceof DoubleFramedBlockEntityBase) {
            world.removeBlockEntity(pos);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> getTicker(Level level, BlockState state, BlockEntityType<S> bet) {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return DoubleFramedBlockEntityFactory.create(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.framed_double_block.detailed_1"));
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.framed_double_block.detailed_2"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.shift_1"));
        }
    }
}

