/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks.FramedBlocks;

import io.github.lordfetzi.entity.custom.FramedBlockEntityBase;
import io.github.lordfetzi.entity.custom.FramedBlockEntityFactory;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FenceGateBlockFramedBlock
extends FenceGateBlock
implements EntityBlock {
    public FenceGateBlockFramedBlock(BlockBehaviour.Properties properties, WoodType type) {
        super(type, properties);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item;
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty() && (item = heldItem.getItem()) instanceof BlockItem) {
            FramedBlockEntityBase framedBlockEntity;
            BlockItem blockItem = (BlockItem)item;
            if (blockItem.getBlock().arch$registryName().getNamespace().equals("fetzisasiandeco") && (blockItem.getBlock().arch$registryName().toString().contains("framed_block") || blockItem.getBlock().arch$registryName().toString().contains("framed_double_block"))) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof FramedBlockEntityBase && !(framedBlockEntity = (FramedBlockEntityBase)blockEntity).hasTexture()) {
                framedBlockEntity.setTexture(blockItem.getBlock().arch$registryName().toString());
                framedBlockEntity.setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
                world.playSound(null, pos, blockItem.getBlock().defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.getDirection().equals((Object)Direction.NORTH) && ((Direction)state.getValue((Property)FACING)).equals((Object)Direction.SOUTH)) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
        } else if (player.getDirection().equals((Object)Direction.SOUTH) && ((Direction)state.getValue((Property)FACING)).equals((Object)Direction.NORTH)) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.SOUTH);
        } else if (player.getDirection().equals((Object)Direction.WEST) && ((Direction)state.getValue((Property)FACING)).equals((Object)Direction.EAST)) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.WEST);
        } else if (player.getDirection().equals((Object)Direction.EAST) && ((Direction)state.getValue((Property)FACING)).equals((Object)Direction.WEST)) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.EAST);
        }
        state = (BlockState)state.cycle((Property)OPEN);
        world.setBlock(pos, state, 2);
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            world.playSound(null, pos, SoundEvents.FENCE_GATE_OPEN, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.2f + 0.8f);
        } else {
            world.playSound(null, pos, SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.2f + 0.8f);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> getTicker(Level level, BlockState state, BlockEntityType<S> bet) {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return FramedBlockEntityFactory.create(pos, state);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = world.getBlockEntity(pos)) instanceof FramedBlockEntityBase) {
            world.removeBlockEntity(pos);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntityBase) {
            ResourceLocation resourceLocation;
            Block textureBlock;
            String textureId;
            FramedBlockEntityBase framedBlockEntity = (FramedBlockEntityBase)blockEntity;
            if (!player.isCreative() && (textureId = framedBlockEntity.getTexture()) != null && (textureBlock = (Block)BuiltInRegistries.BLOCK.get(resourceLocation = ResourceLocation.parse((String)textureId))) != Blocks.AIR) {
                ItemStack dropStack = new ItemStack((ItemLike)textureBlock);
                FenceGateBlockFramedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)dropStack);
            }
        }
        super.playerWillDestroy(world, pos, state, player);
        return state;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.framed_block.detailed_1"));
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.framed_block.detailed_2"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.shift_1"));
        }
    }
}

