/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks.FramedBlocks;

import io.github.lordfetzi.blocks.HandRail;
import io.github.lordfetzi.entity.custom.DoubleFramedBlockEntityBase;
import io.github.lordfetzi.entity.custom.DoubleFramedBlockEntityFactory;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class HandRailFramedBlock
extends HandRail
implements EntityBlock {
    public HandRailFramedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item;
        ItemStack heldItem = player.getItemInHand(hand);
        if (!world.isClientSide && (item = heldItem.getItem()) instanceof BlockItem) {
            DoubleFramedBlockEntityBase framedBlockEntity;
            boolean isSameBlock;
            BlockItem blockItem = (BlockItem)item;
            boolean bl = isSameBlock = blockItem.getBlock() == this;
            if (!isSameBlock && blockItem.getBlock().arch$registryName().getNamespace().equals("fetzisasiandeco") && (blockItem.getBlock().arch$registryName().toString().contains("framed_block") || blockItem.getBlock().arch$registryName().toString().contains("framed_double_block"))) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof DoubleFramedBlockEntityBase && !(framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity).hasTexture1() && !isSameBlock) {
                framedBlockEntity.setTexture1(blockItem.getBlock().arch$registryName().toString());
                framedBlockEntity.setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
                world.playSound(null, pos, blockItem.getBlock().defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            if (blockEntity instanceof DoubleFramedBlockEntityBase && !(framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity).hasTexture2() && !isSameBlock) {
                framedBlockEntity.setTexture2(blockItem.getBlock().arch$registryName().toString());
                framedBlockEntity.setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
                world.playSound(null, pos, blockItem.getBlock().defaultBlockState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (!world.isClientSide) {
            double X = hit.getLocation().x - (double)hit.getBlockPos().getX();
            double Z = hit.getLocation().z - (double)hit.getBlockPos().getZ();
            Direction blockFacing = (Direction)state.getValue((Property)FACING);
            Direction hitDirection = null;
            if (blockFacing == Direction.NORTH || blockFacing == Direction.SOUTH) {
                if (X < 0.33) {
                    hitDirection = Direction.WEST;
                } else if (X > 0.66) {
                    hitDirection = Direction.EAST;
                } else if (0.33 < X && X < 0.66) {
                    if (blockFacing == Direction.NORTH) {
                        hitDirection = Direction.SOUTH;
                    }
                    if (blockFacing == Direction.SOUTH) {
                        hitDirection = Direction.NORTH;
                    }
                }
            } else if (blockFacing == Direction.WEST || blockFacing == Direction.EAST) {
                if (Z < 0.33) {
                    hitDirection = Direction.NORTH;
                } else if (Z > 0.66) {
                    hitDirection = Direction.SOUTH;
                } else if (0.33 < Z && Z < 0.66) {
                    if (blockFacing == Direction.WEST) {
                        hitDirection = Direction.EAST;
                    }
                    if (blockFacing == Direction.EAST) {
                        hitDirection = Direction.WEST;
                    }
                }
            }
            if (hitDirection != null) {
                ItemStack item2 = player.getItemInHand(hand);
                int getDropAmount = (Integer)state.getValue((Property)DROPS);
                if (item2.getItem() == this.asItem()) {
                    if (hitDirection == Direction.NORTH && !((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                        world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)DROPS, (Comparable)Integer.valueOf(getDropAmount + 1)));
                        if (!player.isCreative()) {
                            item2.shrink(1);
                        }
                        world.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                    if (hitDirection == Direction.EAST && !((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                        world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)DROPS, (Comparable)Integer.valueOf(getDropAmount + 1)));
                        if (!player.isCreative()) {
                            item2.shrink(1);
                        }
                        world.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                    if (hitDirection == Direction.SOUTH && !((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                        world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)DROPS, (Comparable)Integer.valueOf(getDropAmount + 1)));
                        if (!player.isCreative()) {
                            item2.shrink(1);
                        }
                        world.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                    if (hitDirection == Direction.WEST && !((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                        world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)DROPS, (Comparable)Integer.valueOf(getDropAmount + 1)));
                        if (!player.isCreative()) {
                            item2.shrink(1);
                        }
                        world.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof DoubleFramedBlockEntityBase) {
            DoubleFramedBlockEntityBase framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity;
            if (!player.isCreative()) {
                ResourceLocation resourceLocation;
                Block textureBlock;
                String textureId2;
                ResourceLocation resourceLocation2;
                Block textureBlock2;
                String textureId1 = framedBlockEntity.getTexture1();
                if (textureId1 != null && (textureBlock2 = (Block)BuiltInRegistries.BLOCK.get(resourceLocation2 = ResourceLocation.parse((String)textureId1))) != Blocks.AIR) {
                    ItemStack dropStack = new ItemStack((ItemLike)textureBlock2);
                    HandRailFramedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)dropStack);
                }
                if ((textureId2 = framedBlockEntity.getTexture2()) != null && (textureBlock = (Block)BuiltInRegistries.BLOCK.get(resourceLocation = ResourceLocation.parse((String)textureId2))) != Blocks.AIR) {
                    ItemStack dropStack = new ItemStack((ItemLike)textureBlock);
                    HandRailFramedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)dropStack);
                }
            }
        }
        super.playerWillDestroy(world, pos, state, player);
        return state;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = world.getBlockEntity(pos)) instanceof DoubleFramedBlockEntityBase) {
            world.removeBlockEntity(pos);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> getTicker(Level level, BlockState state, BlockEntityType<S> bet) {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return DoubleFramedBlockEntityFactory.create(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.shift_2"));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.framed_double_block.detailed_1"));
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.framed_double_block.detailed_2"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.shift_1"));
        }
    }
}

