/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import io.github.lordfetzi.config.FetzisAsianDecoConfig;
import io.github.lordfetzi.entity.custom.GongBlockEntity;
import io.github.lordfetzi.init.blockEntityInit;
import io.github.lordfetzi.init.soundsInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Gong
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<BellAttachType> ATTACHMENT = EnumProperty.create((String)"attachment", BellAttachType.class);
    public final VoxelShape NORTH_SOUTH = Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625);
    public final VoxelShape WEST_EAST = Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0);
    public static VoxelShape SHAPE = Shapes.empty();

    public Gong(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GongBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeForAttachment(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeForAttachment(state);
    }

    private VoxelShape getShapeForAttachment(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BellAttachType attachment = (BellAttachType)state.getValue(ATTACHMENT);
        if (attachment == BellAttachType.SINGLE_WALL || attachment == BellAttachType.DOUBLE_WALL) {
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return this.NORTH_SOUTH;
            }
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return this.WEST_EAST;
            }
        }
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return this.NORTH_SOUTH;
        }
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return this.WEST_EAST;
        }
        return Shapes.empty();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            if (this.validSide(state, hit)) {
                gongBlockEntity.startRinging(hit.getDirection());
                this.playRandomGongSound(level, pos);
                this.attractMobs(level, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean validSide(BlockState state, BlockHitResult hit) {
        return state.getValue(ATTACHMENT) == BellAttachType.FLOOR || state.getValue(ATTACHMENT) == BellAttachType.CEILING ? hit.getDirection() == state.getValue((Property)FACING) || hit.getDirection() == ((Direction)state.getValue((Property)FACING)).getOpposite() : hit.getDirection() != state.getValue((Property)FACING) || hit.getDirection() != ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos = hit.getBlockPos())) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            Direction hitDirection = hit.getDirection();
            gongBlockEntity.startRinging(hitDirection);
            this.playRandomGongSound(level, pos);
            this.attractMobs(level, pos);
        }
    }

    private void playRandomGongSound(Level level, BlockPos pos) {
        if (level.random.nextBoolean()) {
            level.playSound(null, pos, (SoundEvent)soundsInit.GONG_1.get(), SoundSource.BLOCKS, 1.0f, this.getRandomPitch(level));
        } else {
            level.playSound(null, pos, (SoundEvent)soundsInit.GONG_2.get(), SoundSource.BLOCKS, 1.0f, this.getRandomPitch(level));
        }
    }

    private float getRandomPitch(Level level) {
        return 0.7f + level.random.nextFloat() * 0.3f;
    }

    private void attractMobs(Level level, BlockPos gongPos) {
        int radius = FetzisAsianDecoConfig.getGongAttractRange();
        List mobs = level.getEntitiesOfClass(LivingEntity.class, new AABB(gongPos).inflate((double)radius), mob -> mob.getType() == EntityType.VILLAGER);
        for (LivingEntity mob2 : mobs) {
            if (!(mob2 instanceof PathfinderMob)) continue;
            PathfinderMob pathfindingMob = (PathfinderMob)mob2;
            pathfindingMob.getNavigation().moveTo((double)gongPos.getX() + 0.5, (double)gongPos.getY() + 0.5, (double)gongPos.getZ() + 0.5, 1.0);
        }
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        GongBlockEntity gongBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GongBlockEntity && (gongBlockEntity = (GongBlockEntity)blockEntity).isRinging()) {
            return (int)Math.ceil((1.0 - (double)gongBlockEntity.getRingingTicks() / 100.0) * 15.0);
        }
        return 0;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        BlockEntity blockEntity;
        boolean powered;
        if (!level.isClientSide && (powered = level.hasNeighborSignal(pos)) && (blockEntity = level.getBlockEntity(pos)) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            gongBlockEntity.startRinging(Direction.NORTH);
            this.playRandomGongSound(level, pos);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ATTACHMENT});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        Direction.Axis axis = direction.getAxis();
        if (axis == Direction.Axis.Y) {
            BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
            if (blockState.canSurvive((LevelReader)context.getLevel(), blockPos)) {
                return blockState;
            }
        } else {
            boolean bl = axis == Direction.Axis.X && level.getBlockState(blockPos.west()).isFaceSturdy((BlockGetter)level, blockPos.west(), Direction.EAST) && level.getBlockState(blockPos.east()).isFaceSturdy((BlockGetter)level, blockPos.east(), Direction.WEST) || axis == Direction.Axis.Z && level.getBlockState(blockPos.north()).isFaceSturdy((BlockGetter)level, blockPos.north(), Direction.SOUTH) && level.getBlockState(blockPos.south()).isFaceSturdy((BlockGetter)level, blockPos.south(), Direction.NORTH);
            BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue(ATTACHMENT, (Comparable)(bl ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL));
            if (blockState.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
                return blockState;
            }
            boolean bl2 = level.getBlockState(blockPos.below()).isFaceSturdy((BlockGetter)level, blockPos.below(), Direction.UP);
            if ((blockState = (BlockState)blockState.setValue(ATTACHMENT, (Comparable)(bl2 ? BellAttachType.FLOOR : BellAttachType.CEILING))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
                return blockState;
            }
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BellAttachType bellAttachType = (BellAttachType)state.getValue(ATTACHMENT);
        Direction direction2 = Gong.getConnectedDirection(state).getOpposite();
        if (direction2 == direction && !state.canSurvive((LevelReader)level, pos) && bellAttachType != BellAttachType.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction.getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis()) {
            if (bellAttachType == BellAttachType.DOUBLE_WALL && !neighborState.isFaceSturdy((BlockGetter)level, neighborPos, direction)) {
                return (BlockState)((BlockState)state.setValue(ATTACHMENT, (Comparable)BellAttachType.SINGLE_WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            }
            if (bellAttachType == BellAttachType.SINGLE_WALL && direction2.getOpposite() == direction && neighborState.isFaceSturdy((BlockGetter)level, neighborPos, (Direction)state.getValue((Property)FACING))) {
                return (BlockState)state.setValue(ATTACHMENT, (Comparable)BellAttachType.DOUBLE_WALL);
            }
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    private static Direction getConnectedDirection(BlockState state) {
        switch ((BellAttachType)state.getValue(ATTACHMENT)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == blockEntityInit.GONG_ENTITY_TYPE.get()) {
            return (lvl, pos, blockState, blockEntity) -> {
                if (blockEntity instanceof GongBlockEntity) {
                    GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
                    GongBlockEntity.tick(lvl, pos, blockState, gongBlockEntity);
                }
            };
        }
        return null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.shift_2"));
            tooltip.add((Component)Component.empty());
            MutableComponent rangeValue = Component.literal((String)String.valueOf(FetzisAsianDecoConfig.getGongAttractRange())).withStyle(style -> style.withColor(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.gong", (Object[])new Object[]{rangeValue}));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.fetzisasiandeco.shift_1"));
        }
    }
}

