/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HandRail
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static VoxelShape SHAPE = Shapes.empty();
    public static final IntegerProperty DROPS = IntegerProperty.create((String)"drops", (int)1, (int)4);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");

    public HandRail(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)DROPS, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape returnShape = Shapes.empty();
        boolean north = (Boolean)state.getValue((Property)NORTH);
        boolean east = (Boolean)state.getValue((Property)EAST);
        boolean west = (Boolean)state.getValue((Property)WEST);
        boolean south = (Boolean)state.getValue((Property)SOUTH);
        if (north || state.getValue((Property)FACING) == Direction.NORTH) {
            returnShape = Shapes.join((VoxelShape)returnShape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125), (BooleanOp)BooleanOp.OR);
        }
        if (east || state.getValue((Property)FACING) == Direction.EAST) {
            returnShape = Shapes.join((VoxelShape)returnShape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (south || state.getValue((Property)FACING) == Direction.SOUTH) {
            returnShape = Shapes.join((VoxelShape)returnShape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (west || state.getValue((Property)FACING) == Direction.WEST) {
            returnShape = Shapes.join((VoxelShape)returnShape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        return returnShape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape returnShape = Shapes.empty();
        boolean north = (Boolean)state.getValue((Property)NORTH);
        boolean east = (Boolean)state.getValue((Property)EAST);
        boolean west = (Boolean)state.getValue((Property)WEST);
        boolean south = (Boolean)state.getValue((Property)SOUTH);
        if (north || state.getValue((Property)FACING) == Direction.NORTH) {
            returnShape = Shapes.join((VoxelShape)returnShape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.3, (double)0.125), (BooleanOp)BooleanOp.OR);
        }
        if (east || state.getValue((Property)FACING) == Direction.EAST) {
            returnShape = Shapes.join((VoxelShape)returnShape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)1.3, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (south || state.getValue((Property)FACING) == Direction.SOUTH) {
            returnShape = Shapes.join((VoxelShape)returnShape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.3, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (west || state.getValue((Property)FACING) == Direction.WEST) {
            returnShape = Shapes.join((VoxelShape)returnShape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.3, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        return returnShape;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide) {
            double X = hit.getLocation().x - (double)hit.getBlockPos().getX();
            double Z = hit.getLocation().z - (double)hit.getBlockPos().getZ();
            Direction blockFacing = (Direction)state.getValue((Property)FACING);
            Direction hitDirection = null;
            if (blockFacing == Direction.NORTH || blockFacing == Direction.SOUTH) {
                if (X < 0.33) {
                    hitDirection = Direction.WEST;
                } else if (X > 0.66) {
                    hitDirection = Direction.EAST;
                } else if (0.33 < X && X < 0.66) {
                    if (blockFacing == Direction.NORTH) {
                        hitDirection = Direction.SOUTH;
                    }
                    if (blockFacing == Direction.SOUTH) {
                        hitDirection = Direction.NORTH;
                    }
                }
            } else if (blockFacing == Direction.WEST || blockFacing == Direction.EAST) {
                if (Z < 0.33) {
                    hitDirection = Direction.NORTH;
                } else if (Z > 0.66) {
                    hitDirection = Direction.SOUTH;
                } else if (0.33 < Z && Z < 0.66) {
                    if (blockFacing == Direction.WEST) {
                        hitDirection = Direction.EAST;
                    }
                    if (blockFacing == Direction.EAST) {
                        hitDirection = Direction.WEST;
                    }
                }
            }
            if (hitDirection != null) {
                ItemStack item = player.getItemInHand(hand);
                int getDropAmount = (Integer)state.getValue((Property)DROPS);
                if (item.getItem() == this.asItem()) {
                    if (hitDirection == Direction.NORTH && !((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)DROPS, (Comparable)Integer.valueOf(getDropAmount + 1)));
                        if (!player.isCreative()) {
                            item.shrink(1);
                        }
                        level.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                    if (hitDirection == Direction.EAST && !((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)DROPS, (Comparable)Integer.valueOf(getDropAmount + 1)));
                        if (!player.isCreative()) {
                            item.shrink(1);
                        }
                        level.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                    if (hitDirection == Direction.SOUTH && !((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)DROPS, (Comparable)Integer.valueOf(getDropAmount + 1)));
                        if (!player.isCreative()) {
                            item.shrink(1);
                        }
                        level.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                    if (hitDirection == Direction.WEST && !((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)DROPS, (Comparable)Integer.valueOf(getDropAmount + 1)));
                        if (!player.isCreative()) {
                            item.shrink(1);
                        }
                        level.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, FACING, DROPS, WATERLOGGED});
    }
}

