/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PagodaLantern
extends LanternBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final VoxelShape SHAPE = PagodaLantern.FloorShape();
    private static final VoxelShape SHAPE_HANGING = PagodaLantern.HangingShape();

    public PagodaLantern(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape FloorShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.84375, (double)0.8125), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape HangingShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.03125, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public void animateTick(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        float chance = 0.05f;
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)pos.getX() + 0.5, (double)pos.getY() + 0.46, (double)pos.getZ() + 0.5, 0.0, 5.0E-4, 0.0);
            if (chance < rand.nextFloat()) {
                worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 1.0E-5, 0.0);
            }
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && ((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 5.0E-4, 0.0);
            if (chance < rand.nextFloat()) {
                worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.54, (double)pos.getZ() + 0.5, 0.0, 1.0E-5, 0.0);
            }
        }
        super.animateTick(state, worldIn, pos, rand);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Optional<BlockState> optional = PagodaLantern.toggleLight(state, level, pos, player, hand);
        if (optional.isPresent()) {
            if (!level.isClientSide) {
                level.setBlockAndUpdate(pos, optional.get());
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static Optional<BlockState> toggleLight(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (player.getAbilities().mayBuild && handIn == InteractionHand.MAIN_HAND) {
            ItemStack item = player.getItemInHand(handIn);
            if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                if (item.getItem() instanceof FlintAndSteelItem) {
                    worldIn.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, worldIn.getRandom().nextFloat() * 0.4f + 0.8f);
                    state = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
                    item.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(item));
                    return Optional.of(state);
                }
                if (item.getItem() instanceof FireChargeItem) {
                    worldIn.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (worldIn.getRandom().nextFloat() - worldIn.getRandom().nextFloat()) * 0.2f + 1.0f);
                    state = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
                    if (!player.isCreative()) {
                        item.shrink(1);
                    }
                    return Optional.of(state);
                }
            } else if (item.isEmpty()) {
                worldIn.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.5f, 1.5f);
                state = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
                return Optional.of(state);
            }
        }
        return Optional.empty();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockState;
            if (direction.getAxis() != Direction.Axis.Y || !(blockState = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)((BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{WATERLOGGED}).add(new Property[]{HANGING}).add(new Property[]{LIT});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return !this.canSurvive(state, (LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? SHAPE_HANGING : SHAPE;
    }
}

