/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import io.github.lordfetzi.blocks.Panel;
import io.github.lordfetzi.blocks.SlidingDoors;
import io.github.lordfetzi.blocks.SlidingTrapdoors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShojiWall
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");

    public ShojiWall(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean north = (Boolean)state.getValue((Property)NORTH);
        boolean east = (Boolean)state.getValue((Property)EAST);
        boolean west = (Boolean)state.getValue((Property)WEST);
        boolean south = (Boolean)state.getValue((Property)SOUTH);
        VoxelShape shape = Shapes.empty();
        if (!(north || west || east || south)) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0000625, (double)0.625), (BooleanOp)BooleanOp.OR);
        }
        if (north) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        }
        if (east) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        }
        if (south) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (west) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean north = (Boolean)state.getValue((Property)NORTH);
        boolean east = (Boolean)state.getValue((Property)EAST);
        boolean west = (Boolean)state.getValue((Property)WEST);
        boolean south = (Boolean)state.getValue((Property)SOUTH);
        VoxelShape returnCollision = Shapes.empty();
        if (!(north || west || east || south)) {
            returnCollision = Shapes.join((VoxelShape)returnCollision, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0000625, (double)0.625), (BooleanOp)BooleanOp.OR);
        }
        if (north) {
            returnCollision = Shapes.join((VoxelShape)returnCollision, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        }
        if (east) {
            returnCollision = Shapes.join((VoxelShape)returnCollision, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        }
        if (south) {
            returnCollision = Shapes.join((VoxelShape)returnCollision, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (west) {
            returnCollision = Shapes.join((VoxelShape)returnCollision, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        }
        return returnCollision;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH}).add(new Property[]{EAST}).add(new Property[]{SOUTH}).add(new Property[]{WEST}).add(new Property[]{UP}).add(new Property[]{DOWN}).add(new Property[]{WATERLOGGED});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = this.isWall(level, pos, Direction.NORTH);
        boolean east = this.isWall(level, pos, Direction.EAST);
        boolean south = this.isWall(level, pos, Direction.SOUTH);
        boolean west = this.isWall(level, pos, Direction.WEST);
        boolean up = this.isWall(level, pos, Direction.UP);
        boolean down = this.isWall(level, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    private boolean isWall(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.getBlockState(source.relative(direction));
        boolean connectable = false;
        if (direction == Direction.DOWN) {
            if (state.getBlock() instanceof ShojiWall || state.getBlock() instanceof SlidingDoors || state.getBlock() instanceof SlidingTrapdoors) {
                connectable = true;
            }
        } else if (state.getBlock() instanceof ShojiWall || state.getBlock() instanceof SlidingDoors || state.getBlock() instanceof SlidingTrapdoors || state.getBlock() instanceof Block && !state.isAir() && state.isSolid() && !state.is(BlockTags.FENCES) && !state.is(BlockTags.PRESSURE_PLATES) && !state.is(BlockTags.TRAPDOORS) && !state.is(BlockTags.BEDS) || state.getBlock() instanceof Panel) {
            connectable = true;
        }
        return connectable;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }
}

