/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import io.github.lordfetzi.init.soundsInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlidingTrapdoors
extends TrapDoorBlock
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NORTH = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return EAST;
            }
            case EAST: {
                return NORTH;
            }
        }
        return NORTH;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return Shapes.empty();
        }
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: 
            case SOUTH: {
                return EAST;
            }
            case EAST: 
            case WEST: {
                return NORTH;
            }
        }
        return null;
    }

    public SlidingTrapdoors(BlockBehaviour.Properties properties, BlockSetType setType) {
        super(setType, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HALF, (Comparable)Half.BOTTOM)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING, OPEN, POWERED, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.defaultFluidState() : super.getFluidState(state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 2);
        level.playSound(null, pos, (SoundEvent)soundsInit.SLIDE.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.2f + 0.8f);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.getFluidTicks().hasScheduledTick(pos, (Object)Fluids.WATER);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.relative(state.getValue((Property)TrapDoorBlock.HALF) == Half.BOTTOM ? Direction.UP : Direction.DOWN))) {
            state = (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, state, 2);
            level.playSound(null, pos, (SoundEvent)soundsInit.SLIDE.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.2f + 0.8f);
        } else if (!level.hasNeighborSignal(pos) || !level.hasNeighborSignal(pos.relative(state.getValue((Property)TrapDoorBlock.HALF) == Half.BOTTOM ? Direction.UP : Direction.DOWN))) {
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                level.playSound(null, pos, (SoundEvent)soundsInit.SLIDE.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.2f + 0.8f);
            }
            state = (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, state, 2);
        }
    }
}

