/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TallRoofTop
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    private static final VoxelShape SHAPE = TallRoofTop.makeShape();

    public TallRoofTop(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH}).add(new Property[]{EAST}).add(new Property[]{SOUTH}).add(new Property[]{WEST}).add(new Property[]{FACING}).add(new Property[]{WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = this.isRoofTop(level, pos, Direction.NORTH);
        boolean east = this.isRoofTop(level, pos, Direction.EAST);
        boolean south = this.isRoofTop(level, pos, Direction.SOUTH);
        boolean west = this.isRoofTop(level, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean isRoofTop(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.getBlockState(source.relative(direction));
        boolean connectable = false;
        if (state.getBlock() instanceof TallRoofTop) {
            connectable = true;
        }
        return connectable;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }
}

