/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import io.github.lordfetzi.entity.custom.SeatEntityCarpet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Tatami
extends CarpetBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty N_NEIGHBOR_SAME_FACING = BooleanProperty.create((String)"n_nb_same");
    public static final BooleanProperty E_NEIGHBOR_SAME_FACING = BooleanProperty.create((String)"e_nb_same");
    public static final BooleanProperty W_NEIGHBOR_SAME_FACING = BooleanProperty.create((String)"w_nb_same");
    public static final BooleanProperty S_NEIGHBOR_SAME_FACING = BooleanProperty.create((String)"s_nb_same");
    private static VoxelShape SHAPE = Tatami.makeShape();

    public Tatami(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)N_NEIGHBOR_SAME_FACING, (Comparable)Boolean.valueOf(false))).setValue((Property)E_NEIGHBOR_SAME_FACING, (Comparable)Boolean.valueOf(false))).setValue((Property)W_NEIGHBOR_SAME_FACING, (Comparable)Boolean.valueOf(false))).setValue((Property)S_NEIGHBOR_SAME_FACING, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = this.isCarpet(level, pos, Direction.NORTH);
        boolean east = this.isCarpet(level, pos, Direction.EAST);
        boolean south = this.isCarpet(level, pos, Direction.SOUTH);
        boolean west = this.isCarpet(level, pos, Direction.WEST);
        boolean n_nb_same = false;
        boolean e_nb_same = false;
        boolean s_nb_same = false;
        boolean w_nb_same = false;
        if (this.getCarpetFacing(level, pos, Direction.NORTH) == state.getValue((Property)FACING)) {
            n_nb_same = true;
        }
        if (this.getCarpetFacing(level, pos, Direction.EAST) == state.getValue((Property)FACING)) {
            e_nb_same = true;
        }
        if (this.getCarpetFacing(level, pos, Direction.SOUTH) == state.getValue((Property)FACING)) {
            s_nb_same = true;
        }
        if (this.getCarpetFacing(level, pos, Direction.WEST) == state.getValue((Property)FACING)) {
            w_nb_same = true;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)N_NEIGHBOR_SAME_FACING, (Comparable)Boolean.valueOf(n_nb_same))).setValue((Property)E_NEIGHBOR_SAME_FACING, (Comparable)Boolean.valueOf(e_nb_same))).setValue((Property)W_NEIGHBOR_SAME_FACING, (Comparable)Boolean.valueOf(w_nb_same))).setValue((Property)S_NEIGHBOR_SAME_FACING, (Comparable)Boolean.valueOf(s_nb_same));
    }

    private boolean isCarpet(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.getBlockState(source.relative(direction));
        boolean connectable = false;
        if (state.getBlock() instanceof Tatami) {
            connectable = true;
        }
        return connectable;
    }

    private Direction getCarpetFacing(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.getBlockState(source.relative(direction));
        Direction FACINGDIR = null;
        if (state.getBlock() instanceof Tatami) {
            FACINGDIR = (Direction)state.getValue((Property)FACING);
        }
        return FACINGDIR;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH}).add(new Property[]{EAST}).add(new Property[]{SOUTH}).add(new Property[]{WEST}).add(new Property[]{N_NEIGHBOR_SAME_FACING}).add(new Property[]{E_NEIGHBOR_SAME_FACING}).add(new Property[]{S_NEIGHBOR_SAME_FACING}).add(new Property[]{W_NEIGHBOR_SAME_FACING}).add(new Property[]{FACING});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return SeatEntityCarpet.create(level, pos, 0.05, player, ((Direction)state.getValue((Property)FACING)).getOpposite());
    }
}

