/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import io.github.lordfetzi.blocks.VerticalSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalCorner
extends VerticalSlab {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty QUARTER = BooleanProperty.create((String)"quarter");
    public static final BooleanProperty THIRD = BooleanProperty.create((String)"third");
    private static final VoxelShape SHAPE_NORTH_PILLAR = VerticalCorner.makeShape_NORTH_PILLAR();
    private static final VoxelShape SHAPE_SOUTH_PILLAR = VerticalCorner.makeShape_SOUTH_PILLAR();
    private static final VoxelShape SHAPE_WEST_PILLAR = VerticalCorner.makeShape_WEST_PILLAR();
    private static final VoxelShape SHAPE_EAST_PILLAR = VerticalCorner.makeShape_EAST_PILLAR();
    private static final VoxelShape SHAPE_NORTH_SLAB = VerticalCorner.makeShape_NORTH_SLAB();
    private static final VoxelShape SHAPE_SOUTH_SLAB = VerticalCorner.makeShape_SOUTH_SLAB();
    private static final VoxelShape SHAPE_WEST_SLAB = VerticalCorner.makeShape_WEST_SLAB();
    private static final VoxelShape SHAPE_EAST_SLAB = VerticalCorner.makeShape_EAST_SLAB();
    private static final VoxelShape SHAPE_NORTH_L = Shapes.join((VoxelShape)SHAPE_NORTH_SLAB, (VoxelShape)SHAPE_EAST_PILLAR, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH_L = Shapes.join((VoxelShape)SHAPE_SOUTH_SLAB, (VoxelShape)SHAPE_WEST_PILLAR, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST_L = Shapes.join((VoxelShape)SHAPE_WEST_SLAB, (VoxelShape)SHAPE_NORTH_PILLAR, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST_L = Shapes.join((VoxelShape)SHAPE_EAST_SLAB, (VoxelShape)SHAPE_SOUTH_PILLAR, (BooleanOp)BooleanOp.OR);

    public VerticalCorner(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)QUARTER, (Comparable)Boolean.valueOf(true))).setValue((Property)HALF, (Comparable)Boolean.valueOf(false))).setValue((Property)THIRD, (Comparable)Boolean.valueOf(false))).setValue((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape_EAST_PILLAR() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_WEST_PILLAR() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_NORTH_PILLAR() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_SOUTH_PILLAR() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_SOUTH_SLAB() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_NORTH_SLAB() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_EAST_SLAB() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_WEST_SLAB() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = context.getLevel().getBlockState(blockpos);
        if (blockstate.is((Block)this) && ((Boolean)blockstate.getValue((Property)QUARTER)).booleanValue()) {
            return (BlockState)((BlockState)blockstate.setValue((Property)QUARTER, (Comparable)Boolean.FALSE)).setValue((Property)HALF, (Comparable)Boolean.TRUE);
        }
        if (blockstate.is((Block)this) && ((Boolean)blockstate.getValue((Property)HALF)).booleanValue()) {
            return (BlockState)((BlockState)blockstate.setValue((Property)HALF, (Comparable)Boolean.FALSE)).setValue((Property)THIRD, (Comparable)Boolean.TRUE);
        }
        if (blockstate.is((Block)this) && ((Boolean)blockstate.getValue((Property)THIRD)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)THIRD, (Comparable)Boolean.FALSE)).setValue((Property)FULL, (Comparable)Boolean.TRUE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape returnShape = Shapes.empty();
        if (state.getValue((Property)FACING) == Direction.NORTH) {
            if (((Boolean)state.getValue((Property)QUARTER)).booleanValue()) {
                returnShape = SHAPE_NORTH_PILLAR;
            } else if (((Boolean)state.getValue((Property)HALF)).booleanValue()) {
                returnShape = SHAPE_NORTH_SLAB;
            } else if (((Boolean)state.getValue((Property)THIRD)).booleanValue()) {
                returnShape = SHAPE_NORTH_L;
            } else if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
                returnShape = Shapes.block();
            }
        } else if (state.getValue((Property)FACING) == Direction.SOUTH) {
            if (((Boolean)state.getValue((Property)QUARTER)).booleanValue()) {
                returnShape = SHAPE_SOUTH_PILLAR;
            } else if (((Boolean)state.getValue((Property)HALF)).booleanValue()) {
                returnShape = SHAPE_SOUTH_SLAB;
            } else if (((Boolean)state.getValue((Property)THIRD)).booleanValue()) {
                returnShape = SHAPE_SOUTH_L;
            } else if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
                returnShape = Shapes.block();
            }
        } else if (state.getValue((Property)FACING) == Direction.WEST) {
            if (((Boolean)state.getValue((Property)QUARTER)).booleanValue()) {
                returnShape = SHAPE_WEST_PILLAR;
            } else if (((Boolean)state.getValue((Property)HALF)).booleanValue()) {
                returnShape = SHAPE_WEST_SLAB;
            } else if (((Boolean)state.getValue((Property)THIRD)).booleanValue()) {
                returnShape = SHAPE_WEST_L;
            } else if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
                returnShape = Shapes.block();
            }
        } else if (state.getValue((Property)FACING) == Direction.EAST) {
            if (((Boolean)state.getValue((Property)QUARTER)).booleanValue()) {
                returnShape = SHAPE_EAST_PILLAR;
            } else if (((Boolean)state.getValue((Property)HALF)).booleanValue()) {
                returnShape = SHAPE_EAST_SLAB;
            } else if (((Boolean)state.getValue((Property)THIRD)).booleanValue()) {
                returnShape = SHAPE_EAST_L;
            } else if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
                returnShape = Shapes.block();
            }
        }
        return returnShape;
    }

    @Override
    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        return (Boolean)state.getValue((Property)FULL) == false && stack.getItem() == this.asItem();
    }

    public boolean placeLiquid(LevelAccessor p_56368_, BlockPos p_56369_, BlockState state, FluidState p_56371_) {
        boolean canbeplaced = false;
        if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            canbeplaced = false;
        } else if (((Boolean)state.getValue((Property)THIRD)).booleanValue()) {
            canbeplaced = true;
            super.placeLiquid(p_56368_, p_56369_, state, p_56371_);
        } else if (((Boolean)state.getValue((Property)HALF)).booleanValue()) {
            canbeplaced = true;
            super.placeLiquid(p_56368_, p_56369_, state, p_56371_);
        } else if (((Boolean)state.getValue((Property)QUARTER)).booleanValue()) {
            canbeplaced = true;
            super.placeLiquid(p_56368_, p_56369_, state, p_56371_);
        }
        return canbeplaced;
    }

    @Override
    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        boolean canbeplaced = false;
        if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            canbeplaced = false;
        }
        return canbeplaced;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{QUARTER}).add(new Property[]{THIRD});
    }
}

