/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalSlab
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HALF = BooleanProperty.create((String)"half");
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");
    private static VoxelShape SHAPE_NORTH = VerticalSlab.makeShape_NORTH();
    private static VoxelShape SHAPE_SOUTH = VerticalSlab.makeShape_SOUTH();
    private static VoxelShape SHAPE_WEST = VerticalSlab.makeShape_WEST();
    private static VoxelShape SHAPE_EAST = VerticalSlab.makeShape_EAST();

    public VerticalSlab(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HALF, (Comparable)Boolean.valueOf(true))).setValue((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape_SOUTH() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_NORTH() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_EAST() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShape_WEST() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape returnShape = Shapes.empty();
        if (((Boolean)state.getValue((Property)HALF)).booleanValue()) {
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    returnShape = SHAPE_NORTH;
                    break;
                }
                case SOUTH: {
                    returnShape = SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    returnShape = SHAPE_WEST;
                    break;
                }
                case EAST: {
                    returnShape = SHAPE_EAST;
                }
            }
        } else if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            returnShape = Shapes.block();
        }
        return returnShape;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = context.getLevel().getBlockState(blockpos);
        FluidState fluidState = context.getLevel().getFluidState(blockpos);
        if (blockstate.is((Block)this) && ((Boolean)blockstate.getValue((Property)HALF)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)HALF, (Comparable)Boolean.valueOf(false))).setValue((Property)FULL, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        return (Boolean)state.getValue((Property)FULL) == false && stack.getItem() == this.asItem();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        boolean canbeplaced = true;
        if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            canbeplaced = false;
        }
        return canbeplaced;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, HALF, FULL});
    }
}

