/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ZenBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static VoxelShape SHAPE = ZenBlock.makeShape();
    public static final BooleanProperty STRAIGHT = BooleanProperty.create((String)"straight");
    public static final BooleanProperty CURVE = BooleanProperty.create((String)"curve");
    public static final BooleanProperty STRAIGHT_CURVE = BooleanProperty.create((String)"straight_curve");

    public ZenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)STRAIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)CURVE, (Comparable)Boolean.valueOf(false))).setValue((Property)STRAIGHT_CURVE, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)6.25E-5, (double)0.0, (double)6.25E-5, (double)0.9999375, (double)1.0, (double)0.9999375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Optional<BlockState> optional = ZenBlock.swapZenBlock(state, level, pos, player, hand);
        if (optional.isPresent()) {
            if (!level.isClientSide) {
                level.setBlockAndUpdate(pos, optional.get());
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static Optional<BlockState> swapZenBlock(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (player.getAbilities().mayBuild && handIn == InteractionHand.MAIN_HAND) {
            ItemStack item = player.getItemInHand(handIn);
            if (!((Boolean)state.getValue((Property)STRAIGHT)).booleanValue() && !((Boolean)state.getValue((Property)CURVE)).booleanValue() && !((Boolean)state.getValue((Property)STRAIGHT_CURVE)).booleanValue() && item.getItem() instanceof HoeItem) {
                worldIn.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, worldIn.getRandom().nextFloat() * 0.4f + 0.8f);
                state = (BlockState)state.setValue((Property)STRAIGHT, (Comparable)Boolean.valueOf(true));
                item.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(item));
                return Optional.of(state);
            }
            if (((Boolean)state.getValue((Property)STRAIGHT)).booleanValue() && item.getItem() instanceof HoeItem) {
                worldIn.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, worldIn.getRandom().nextFloat() * 0.4f + 0.8f);
                state = (BlockState)state.setValue((Property)STRAIGHT, (Comparable)Boolean.valueOf(false));
                state = (BlockState)state.setValue((Property)CURVE, (Comparable)Boolean.valueOf(true));
                item.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(item));
                return Optional.of(state);
            }
            if (((Boolean)state.getValue((Property)CURVE)).booleanValue() && item.getItem() instanceof HoeItem) {
                worldIn.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, worldIn.getRandom().nextFloat() * 0.4f + 0.8f);
                state = (BlockState)state.setValue((Property)CURVE, (Comparable)Boolean.valueOf(false));
                state = (BlockState)state.setValue((Property)STRAIGHT_CURVE, (Comparable)Boolean.valueOf(true));
                item.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(item));
                return Optional.of(state);
            }
            if (((Boolean)state.getValue((Property)STRAIGHT_CURVE)).booleanValue() && item.getItem() instanceof HoeItem) {
                worldIn.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, worldIn.getRandom().nextFloat() * 0.4f + 0.8f);
                state = (BlockState)state.setValue((Property)STRAIGHT_CURVE, (Comparable)Boolean.valueOf(false));
                state = (BlockState)state.setValue((Property)STRAIGHT, (Comparable)Boolean.valueOf(true));
                item.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(item));
                return Optional.of(state);
            }
            if ((((Boolean)state.getValue((Property)STRAIGHT_CURVE)).booleanValue() || ((Boolean)state.getValue((Property)STRAIGHT)).booleanValue() || ((Boolean)state.getValue((Property)CURVE)).booleanValue()) && item.getItem() instanceof ShovelItem) {
                worldIn.playSound(null, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, worldIn.getRandom().nextFloat() * 0.4f + 0.8f);
                state = (BlockState)state.setValue((Property)STRAIGHT_CURVE, (Comparable)Boolean.valueOf(false));
                state = (BlockState)state.setValue((Property)STRAIGHT, (Comparable)Boolean.valueOf(false));
                state = (BlockState)state.setValue((Property)CURVE, (Comparable)Boolean.valueOf(false));
                item.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(item));
                return Optional.of(state);
            }
        }
        return Optional.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{STRAIGHT}).add(new Property[]{STRAIGHT_CURVE}).add(new Property[]{CURVE});
    }
}

