/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FetzisAsianDecoConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("fetzis_asian_deco/fetzis-asian-deco-config.json");
    private static ConfigData configData = new ConfigData();
    private static final String CURRENT_MOD_VERSION = "1.7.3";

    public static void loadConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                configData = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (!CURRENT_MOD_VERSION.equals(FetzisAsianDecoConfig.configData.modVersion)) {
                    System.out.println("[Fetzi's Asian Decoration] Config version mismatch. Updating config...");
                    FetzisAsianDecoConfig.configData.modVersion = CURRENT_MOD_VERSION;
                    FetzisAsianDecoConfig.saveConfig();
                }
            }
            catch (JsonSyntaxException | IOException e) {
                System.err.println("[Fetzi's Asian Decoration] Failed to load config, using default settings.");
                e.printStackTrace();
                FetzisAsianDecoConfig.saveConfig();
            }
        } else {
            FetzisAsianDecoConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)configData, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[Fetzi's Asian Decoration] Failed to save config.");
            e.printStackTrace();
        }
    }

    public static boolean getChatMessageOnJoin() {
        return FetzisAsianDecoConfig.configData.chatMessageOnJoin;
    }

    public static void setChatMessageOnJoin(boolean value) {
        FetzisAsianDecoConfig.configData.chatMessageOnJoin = value;
        FetzisAsianDecoConfig.saveConfig();
    }

    public static boolean getChatMessageOnce() {
        return FetzisAsianDecoConfig.configData.chatMessageOnce;
    }

    public static void setChatMessageOnce(boolean value) {
        FetzisAsianDecoConfig.configData.chatMessageOnce = value;
        FetzisAsianDecoConfig.saveConfig();
    }

    public static boolean getKoiSpawnEnabled() {
        return FetzisAsianDecoConfig.configData.spawnKois;
    }

    public static void setKoiSpawnEnabled(boolean value) {
        FetzisAsianDecoConfig.configData.spawnKois = value;
        FetzisAsianDecoConfig.saveConfig();
    }

    public static int getWeightKoi() {
        return FetzisAsianDecoConfig.configData.weightKoi;
    }

    public static void setWeightKoi(int value) {
        FetzisAsianDecoConfig.configData.weightKoi = value;
        FetzisAsianDecoConfig.saveConfig();
    }

    public static int getMinCountKoi() {
        return FetzisAsianDecoConfig.configData.minCountKoi;
    }

    public static void setMinCountKoi(int value) {
        FetzisAsianDecoConfig.configData.minCountKoi = value;
        FetzisAsianDecoConfig.saveConfig();
    }

    public static int getMaxCountKoi() {
        return FetzisAsianDecoConfig.configData.maxCountKoi;
    }

    public static void setMaxCountKoi(int value) {
        FetzisAsianDecoConfig.configData.maxCountKoi = value;
        FetzisAsianDecoConfig.saveConfig();
    }

    public static boolean getLilyPadGenerationEnabled() {
        return FetzisAsianDecoConfig.configData.generateLilyPads;
    }

    public static void setLilyPadGenerationEnabled(boolean value) {
        FetzisAsianDecoConfig.configData.generateLilyPads = value;
        FetzisAsianDecoConfig.saveConfig();
    }

    public static int getGongAttractRange() {
        return FetzisAsianDecoConfig.configData.gongAttractRange;
    }

    public static void setGongAttractRange(int value) {
        FetzisAsianDecoConfig.configData.gongAttractRange = value;
        FetzisAsianDecoConfig.saveConfig();
    }

    private static class ConfigData {
        String modVersion = "1.7.3";
        String configWiki = "https://fetzis-orga.gitbook.io/fetzis-asian-decoration/config-settings";
        boolean chatMessageOnJoin = true;
        boolean chatMessageOnce = true;
        boolean spawnKois = true;
        int weightKoi = 5;
        int minCountKoi = 2;
        int maxCountKoi = 5;
        boolean generateLilyPads = true;
        int gongAttractRange = 50;

        private ConfigData() {
        }
    }
}

