/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity;

import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import io.github.lordfetzi.config.FetzisAsianDecoConfig;
import io.github.lordfetzi.entity.client.GongBlockRenderer;
import io.github.lordfetzi.entity.client.KoiModel;
import io.github.lordfetzi.entity.client.KoiRenderer;
import io.github.lordfetzi.entity.client.ModModelLayers;
import io.github.lordfetzi.entity.client.SeatRenderer;
import io.github.lordfetzi.entity.client.SeatRendererFixedRotation;
import io.github.lordfetzi.init.blockEntityInit;
import io.github.lordfetzi.init.blockInit;
import io.github.lordfetzi.init.entityInit;
import io.github.lordfetzi.util.FetzisAsianDecoTextureSpriteCache;
import io.github.lordfetzi.util.TextureStringCache;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FetzisAsianDecoClient {
    public static void initClient() {
        Block block;
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)blockInit.FLOWER_LILY_PAD.get()});
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> world != null && pos != null ? 2129968 : 7455580, (Block[])new Block[]{(Block)blockInit.FLOWER_LILY_PAD.get()});
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)blockEntityInit.GONG_ENTITY_TYPE.get()), GongBlockRenderer::new);
        for (RegistrySupplier<Block> blockSupplier : blockInit.BlockList) {
            block = (Block)blockSupplier.get();
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{block});
        }
        for (RegistrySupplier<Block> blockSupplier : blockInit.FramedBlockList) {
            block = (Block)blockSupplier.get();
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{block});
        }
        FetzisAsianDecoClient.registerResourceReloadListener();
    }

    private static void registerResourceReloadListener() {
        ClientReloadShadersEvent.EVENT.register((minecraft, resourceManager) -> {
            FetzisAsianDecoTextureSpriteCache.clearCaches();
            TextureStringCache.clear();
        });
    }

    public static void preInitClient() {
        FetzisAsianDecoClient.registerEntityRenderers();
        FetzisAsianDecoClient.registerEntityModelLayer();
        FetzisAsianDecoClient.checkConfig();
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(entityInit.SEAT, SeatRenderer::new);
        EntityRendererRegistry.register(entityInit.FIXED_SEAT, SeatRendererFixedRotation::new);
        EntityRendererRegistry.register(entityInit.KOI, KoiRenderer::new);
    }

    public static void registerEntityModelLayer() {
        EntityModelLayerRegistry.register((ModelLayerLocation)ModModelLayers.KOI_LAYER, KoiModel::createBodyLayer);
    }

    public static void checkConfig() {
        FetzisAsianDecoConfig.loadConfig();
    }
}

