/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.lordfetzi.blocks.Gong;
import io.github.lordfetzi.entity.custom.GongBlockEntity;
import io.github.lordfetzi.init.blockInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GongBlockRenderer
implements BlockEntityRenderer<GongBlockEntity> {
    public GongBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(GongBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        float rotationY;
        poseStack.pushPose();
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)Gong.FACING);
        BellAttachType attachment = (BellAttachType)state.getValue(Gong.ATTACHMENT);
        if (attachment == BellAttachType.SINGLE_WALL || attachment == BellAttachType.DOUBLE_WALL) {
            rotationY = switch (facing) {
                case Direction.NORTH -> 90.0f;
                case Direction.SOUTH -> 90.0f;
                case Direction.EAST -> 0.0f;
                case Direction.WEST -> 0.0f;
                default -> 0.0f;
            };
        } else {
            rotationY = switch (facing) {
                case Direction.NORTH -> 0.0f;
                case Direction.SOUTH -> 0.0f;
                case Direction.EAST -> 90.0f;
                case Direction.WEST -> 90.0f;
                default -> 0.0f;
            };
        }
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationY));
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.translate(0.5, 0.95, 0.5);
        if (blockEntity.isRinging()) {
            float progress = ((float)blockEntity.getRingingTicks() + partialTicks) / 100.0f;
            int swingCycles = 5;
            float angle = (float)Math.sin((double)progress * Math.PI * 2.0 * (double)swingCycles) * (25.0f * (1.0f - progress));
            Axis rotationAxis = this.getRotationAxis(blockEntity.getRingDirection());
            poseStack.mulPose(rotationAxis.rotationDegrees(angle));
        }
        poseStack.translate(-0.5, -0.95, -0.5);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(((Block)blockInit.GONG.get()).defaultBlockState(), poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    private Axis getRotationAxis(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Axis.XN;
            case Direction.SOUTH -> Axis.XP;
            case Direction.WEST -> Axis.XN;
            case Direction.EAST -> Axis.XP;
            case Direction.UP -> Axis.XN;
            case Direction.DOWN -> Axis.XP;
        };
    }
}

