/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.lordfetzi.entity.animations.ModAnimationsDefinitions;
import io.github.lordfetzi.entity.custom.KoiEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class KoiModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart koi;

    public KoiModel(ModelPart root) {
        this.koi = root.getChild("koi");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition koi = partdefinition.addOrReplaceChild("koi", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = koi.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, -5.0f, 4.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 4).addBox(-0.001f, -7.0f, 1.0f, 0.001f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-0.001f, -8.0f, -3.0f, 0.001f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(17, 0).addBox(-0.001f, -7.0f, -4.0f, 0.001f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(17, 5).addBox(-0.001f, -2.0f, 1.0f, 0.001f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = torso.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -3.304f, -3.1409f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.696f, (float)-4.8591f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(16, 13).addBox(-0.051f, -1.5f, -0.5f, 0.001f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.1f, (float)0.946f, (float)-1.6409f, (float)0.4363f, (float)0.0f, (float)-0.0436f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(14, 13).addBox(0.099f, -1.5f, -0.5f, 0.001f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.15f, (float)0.946f, (float)-1.6409f, (float)0.4363f, (float)0.0f, (float)0.0436f));
        PartDefinition rightfin = torso.addOrReplaceChild("rightfin", CubeListBuilder.create().texOffs(3, 6).addBox(-1.1667f, -5.0E-4f, 0.3333f, 2.0f, 0.01f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 8).addBox(-1.1667f, -5.0E-4f, -0.6667f, 1.0f, 0.01f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-0.1667f, -5.0E-4f, -1.6667f, 2.0f, 0.01f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.3744f, (float)-1.0617f, (float)-2.3517f, (float)-0.0167f, (float)0.0f, (float)-0.393f));
        PartDefinition rightfin_bottom = torso.addOrReplaceChild("rightfin_bottom", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-1.0f, (float)-0.75f));
        PartDefinition cube_r3 = rightfin_bottom.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(17, 3).addBox(-0.001f, 0.0f, -1.25f, 0.001f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(17, 5).addBox(-0.001f, 1.0f, -0.25f, 0.001f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition leftfin = torso.addOrReplaceChild("leftfin", CubeListBuilder.create().texOffs(0, 7).addBox(-0.8333f, -5.0E-4f, 0.3333f, 2.0f, 0.01f, 1.0f, new CubeDeformation(0.0f)).texOffs(2, 8).addBox(0.1667f, -5.0E-4f, -0.6667f, 1.0f, 0.01f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 2).addBox(-1.8333f, -5.0E-4f, -1.6667f, 2.0f, 0.01f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.6092f, (float)-0.9448f, (float)-2.3645f, (float)-0.0168f, (float)0.0f, (float)0.3938f));
        PartDefinition leftfin_bottom = torso.addOrReplaceChild("leftfin_bottom", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-1.0f, (float)-0.75f));
        PartDefinition cube_r4 = leftfin_bottom.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(17, 3).addBox(-0.001f, 0.0f, -1.25f, 0.001f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(17, 5).addBox(-0.001f, 1.0f, -0.25f, 0.001f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition tailfin = torso.addOrReplaceChild("tailfin", CubeListBuilder.create().texOffs(7, 13).addBox(-0.001f, -2.0f, 0.0f, 0.001f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 13).addBox(-0.001f, -3.0f, 1.0f, 0.001f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 13).addBox(-0.001f, -4.0f, 2.0f, 0.001f, 7.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-0.001f, -4.0f, 3.0f, 0.001f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(7, 7).addBox(-0.001f, -3.0f, 4.0f, 0.001f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-0.001f, 0.0f, 3.0f, 0.001f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 7).addBox(-0.001f, 1.0f, 4.0f, 0.001f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)4.0f));
        PartDefinition bone = tailfin.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(((KoiEntity)((Object)entity)).swimmingAnimationState, ModAnimationsDefinitions.KOI_SWIM, ageInTicks, 1.0f);
        this.animate(((KoiEntity)((Object)entity)).flopAnimationState, ModAnimationsDefinitions.KOI_FLOP, ageInTicks, 0.5f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.koi.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.koi;
    }
}

