/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.custom;

import io.github.lordfetzi.init.blockEntityInit;
import io.github.lordfetzi.util.TextureStringCache;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleFramedBlockEntityBase
extends BlockEntity {
    protected String texture1;
    protected String texture2;

    public DoubleFramedBlockEntityBase(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.DOUBLE_FRAMED_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public String getTexture1() {
        return this.texture1;
    }

    public String getTexture2() {
        return this.texture2;
    }

    public boolean hasTexture1() {
        return this.texture1 != null;
    }

    public boolean hasTexture2() {
        return this.texture2 != null;
    }

    public void setTexture1(String textureId) {
        if (this.level != null && !this.level.isClientSide) {
            if (Objects.equals(this.texture1, textureId)) {
                return;
            }
            try {
                this.texture1 = textureId != null ? TextureStringCache.getOrCache(textureId) : null;
                this.setChanged();
                Level level = this.level;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.getChunkSource().blockChanged(this.getBlockPos());
                }
                this.redraw();
            }
            catch (Exception e) {
                this.texture1 = TextureStringCache.getOrCache("fetzisasiandeco:placeholder_frame");
            }
        }
    }

    public void setTexture2(String textureId) {
        if (this.level != null && !this.level.isClientSide) {
            if (Objects.equals(this.texture2, textureId)) {
                return;
            }
            try {
                this.texture2 = textureId != null ? TextureStringCache.getOrCache(textureId) : null;
                this.setChanged();
                Level level = this.level;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.getChunkSource().blockChanged(this.getBlockPos());
                }
                this.redraw();
            }
            catch (Exception e) {
                this.texture2 = TextureStringCache.getOrCache("fetzisasiandeco:placeholder_solid");
            }
        }
    }

    private void redraw() {
        if (this.hasLevel() && this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 10);
            if (this.getBlockState().getLightEmission() > 0) {
                this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
            }
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.texture1 != null) {
            tag.putString("t1", this.texture1);
        }
        if (this.texture2 != null) {
            tag.putString("t2", this.texture2);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        String loadedTexture;
        super.loadAdditional(tag, registries);
        if (tag.contains("t1")) {
            loadedTexture = tag.getString("t1");
            this.texture1 = TextureStringCache.getOrCache(loadedTexture);
        } else if (tag.contains("texture1")) {
            loadedTexture = tag.getString("texture1");
            this.texture1 = TextureStringCache.getOrCache(loadedTexture);
        }
        if (tag.contains("t2")) {
            loadedTexture = tag.getString("t2");
            this.texture2 = TextureStringCache.getOrCache(loadedTexture);
        } else if (tag.contains("texture2")) {
            loadedTexture = tag.getString("texture2");
            this.texture2 = TextureStringCache.getOrCache(loadedTexture);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        if (this.texture1 != null) {
            tag.putString("t1", this.texture1);
        }
        if (this.texture2 != null) {
            tag.putString("t2", this.texture2);
        }
        return tag;
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        if (tag != null && (tag.contains("t1") || tag.contains("t2"))) {
            this.updateBlockAppearance(tag, registries);
        }
    }

    public void updateBlockAppearance(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag != null) {
            String oldTexture1 = this.texture1;
            String oldTexture2 = this.texture2;
            this.loadWithComponents(tag, registries);
            if (!Objects.equals(oldTexture1, this.texture1) || !Objects.equals(oldTexture2, this.texture2)) {
                this.redraw();
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setRemoved() {
        super.setRemoved();
    }
}

