/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.custom;

import dev.architectury.platform.Platform;
import io.github.lordfetzi.entity.custom.DoubleFramedBlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class DoubleFramedBlockEntityFactory {
    public static DoubleFramedBlockEntityBase create(BlockPos pos, BlockState state) {
        String className;
        if (Platform.isFabric()) {
            className = "io.github.lordfetzi.fabric.entity.custom.DoubleFramedBlockEntityFabric";
        } else if (Platform.isNeoForge()) {
            className = "io.github.lordfetzi.neoforge.entity.custom.DoubleFramedBlockEntityNeoForge";
        } else {
            throw new IllegalStateException("Unsupported platform");
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (DoubleFramedBlockEntityBase)((Object)clazz.getConstructor(BlockPos.class, BlockState.class).newInstance(pos, state));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create DoubleFramedBlockEntity", e);
        }
    }
}

