/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.custom;

import io.github.lordfetzi.init.blockEntityInit;
import io.github.lordfetzi.util.TextureStringCache;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FramedBlockEntityBase
extends BlockEntity {
    protected String texture;

    public FramedBlockEntityBase(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.FRAMED_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public String getTexture() {
        return this.texture;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void setTexture(String textureId) {
        if (this.level != null && !this.level.isClientSide) {
            if (Objects.equals(this.texture, textureId)) {
                return;
            }
            try {
                this.texture = textureId != null ? TextureStringCache.getOrCache(textureId) : null;
                this.setChanged();
                Level level = this.level;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.getChunkSource().blockChanged(this.getBlockPos());
                }
                this.redraw();
            }
            catch (Exception e) {
                this.texture = TextureStringCache.getOrCache("fetzisasiandeco:placeholder_frame");
            }
        }
    }

    private void redraw() {
        if (this.hasLevel() && this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 10);
            if (this.getBlockState().getLightEmission() > 0) {
                this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
            }
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.texture != null) {
            tag.putString("t", this.texture);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("t")) {
            String loadedTexture = tag.getString("t");
            this.texture = TextureStringCache.getOrCache(loadedTexture);
        } else if (tag.contains("texture")) {
            String loadedTexture = tag.getString("texture");
            this.texture = TextureStringCache.getOrCache(loadedTexture);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        if (this.texture != null) {
            tag.putString("t", this.texture);
        }
        return tag;
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        if (tag != null && tag.contains("t")) {
            this.updateBlockAppearance(tag, registries);
        }
    }

    public void updateBlockAppearance(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag != null) {
            String oldTexture = this.texture;
            this.loadWithComponents(tag, registries);
            if (!Objects.equals(oldTexture, this.texture)) {
                this.redraw();
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setRemoved() {
        super.setRemoved();
    }
}

