/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.custom;

import io.github.lordfetzi.init.blockEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FutonBlockEntity
extends BlockEntity {
    private DyeColor color;

    public FutonBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.FUTON_ENTITY_TYPE.get(), pos, state);
        this.color = DyeColor.WHITE;
    }

    public FutonBlockEntity(BlockPos pos, BlockState state, DyeColor color) {
        super((BlockEntityType)blockEntityInit.FUTON_ENTITY_TYPE.get(), pos, state);
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("color")) {
            this.color = DyeColor.byId((int)tag.getInt("color"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("color", this.color.getId());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

