/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.custom;

import io.github.lordfetzi.init.blockEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GongBlockEntity
extends BlockEntity {
    public static final int ANIMATION_DURATION = 100;
    private boolean isRinging;
    private int ringingTicks;
    private Direction ringDirection;

    public GongBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.GONG_ENTITY_TYPE.get(), pos, state);
    }

    public void startRinging(Direction direction) {
        this.isRinging = true;
        this.ringingTicks = 0;
        this.ringDirection = direction;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GongBlockEntity entity) {
        if (entity.isRinging) {
            ++entity.ringingTicks;
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
            if (entity.ringingTicks >= 100) {
                entity.isRinging = false;
                entity.ringingTicks = 0;
                level.sendBlockUpdated(pos, state, state, 3);
                level.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
        }
    }

    public boolean isRinging() {
        return this.isRinging;
    }

    public int getRingingTicks() {
        return this.ringingTicks;
    }

    public Direction getRingDirection() {
        return this.ringDirection;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("isRinging", this.isRinging);
        tag.putInt("ringingTicks", this.ringingTicks);
        if (this.ringDirection != null) {
            tag.putInt("ringDirection", this.ringDirection.get3DDataValue());
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isRinging = tag.getBoolean("isRinging");
        this.ringingTicks = tag.getInt("ringingTicks");
        if (tag.contains("ringDirection")) {
            this.ringDirection = Direction.from3DDataValue((int)tag.getInt("ringDirection"));
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }
}

