/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.custom;

import com.mojang.serialization.Codec;
import io.github.lordfetzi.init.itemInit;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class KoiEntity
extends AbstractSchoolingFish
implements VariantHolder<Pattern> {
    public static final String KOI_BUCKET_VARIANT_TAG = "KoiBucketVariantTag";
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(KoiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final List<Variant> COMMON_VARIANTS = List.of(new Variant(Pattern.WHITE_KOI), new Variant(Pattern.ORANGE_KOI), new Variant(Pattern.AKA_MATSUBA_KOI), new Variant(Pattern.ASAGI_KOI), new Variant(Pattern.BEKKO_KOI), new Variant(Pattern.BENIGOI_KOI), new Variant(Pattern.KARASUGOI_KOI), new Variant(Pattern.KIGOI_KOI), new Variant(Pattern.KOHAKU_KOI), new Variant(Pattern.PLATINUM_KOI), new Variant(Pattern.SHIRO_UTSURI_KOI), new Variant(Pattern.TAISHO_SANSHOKU_KOI), new Variant(Pattern.TANCHO_KOI), new Variant(Pattern.KIN_KI_UTSURI));
    private boolean isSchool = true;
    public final AnimationState swimmingAnimationState = new AnimationState();
    public final AnimationState flopAnimationState = new AnimationState();

    public int getMaxSchoolSize() {
        return 5;
    }

    public KoiEntity(EntityType<? extends KoiEntity> entityType, Level level) {
        super(entityType, level);
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        BlockPos blockpos = this.blockPosition();
        FluidState fluidstate = world.getFluidState(blockpos);
        return fluidstate.is((Fluid)Fluids.WATER) && fluidstate.getAmount() == 8;
    }

    public static String getPredefinedName(int pVariantId) {
        return "entity.fetzisasiandeco.koi.predefined." + pVariantId;
    }

    static int packVariant(Pattern pPattern) {
        return pPattern.getPackedId();
    }

    public static Pattern getPattern(int pVariantId) {
        return Pattern.byId(pVariantId);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getPackedVariant());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setPackedVariant(pCompound.getInt("Variant"));
    }

    private void setPackedVariant(int pPackedVariant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)pPackedVariant);
    }

    public boolean isMaxGroupSizeReached(int pSize) {
        return !this.isSchool;
    }

    private int getPackedVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public Pattern getVariant() {
        return KoiEntity.getPattern(this.getPackedVariant());
    }

    public void setVariant(Pattern pVariant) {
        int i = this.getPackedVariant();
        this.setPackedVariant(KoiEntity.packVariant(pVariant));
    }

    public void saveToBucketTag(ItemStack pStack) {
        super.saveToBucketTag(pStack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)pStack, compoundTag -> compoundTag.putInt(KOI_BUCKET_VARIANT_TAG, this.getPackedVariant()));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)itemInit.KOI_FISH_BUCKET.get());
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.TROPICAL_FISH_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.TROPICAL_FISH_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    public void loadFromBucketTag(CompoundTag tag) {
        super.loadFromBucketTag(tag);
        if (tag.contains(KOI_BUCKET_VARIANT_TAG, 3)) {
            this.setPackedVariant(tag.getInt(KOI_BUCKET_VARIANT_TAG));
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData) {
        Variant tropicalfish$variant;
        Object pSpawnData = super.finalizeSpawn(pLevel, pDifficulty, pReason, spawnGroupData);
        RandomSource randomsource = pLevel.getRandom();
        if (pSpawnData instanceof KoiEntityGroupData) {
            KoiEntityGroupData koi$koigroupdata = (KoiEntityGroupData)((Object)pSpawnData);
            tropicalfish$variant = koi$koigroupdata.variant;
        } else if ((double)randomsource.nextFloat() < 0.9) {
            tropicalfish$variant = (Variant)Util.getRandom(COMMON_VARIANTS, (RandomSource)randomsource);
            pSpawnData = new KoiEntityGroupData(this, tropicalfish$variant);
        } else {
            this.isSchool = false;
            Pattern[] akoi$pattern = Pattern.values();
            Pattern koi$pattern = (Pattern)((Object)Util.getRandom((Object[])akoi$pattern, (RandomSource)randomsource));
            tropicalfish$variant = new Variant(koi$pattern);
        }
        this.setPackedVariant(tropicalfish$variant.getPackedId());
        return pSpawnData;
    }

    public void swimAnimation() {
        this.flopAnimationState.stop();
        this.swimmingAnimationState.start(20);
    }

    public void flopAnimation() {
        this.swimmingAnimationState.stop();
        this.flopAnimationState.start(20);
    }

    private void setupAnimationStates() {
        if (this.isInWater()) {
            this.swimAnimation();
        } else if (this.onGround() && !this.isInWater()) {
            this.flopAnimation();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    public static enum Pattern implements StringRepresentable
    {
        WHITE_KOI("white_koi", Base.NORMAL, 0),
        ORANGE_KOI("orange_koi", Base.NORMAL, 1),
        AKA_MATSUBA_KOI("aka_matsuba_koi", Base.NORMAL, 2),
        ASAGI_KOI("asagi_koi", Base.NORMAL, 3),
        BEKKO_KOI("bekko_koi", Base.NORMAL, 4),
        BENIGOI_KOI("benigoi_koi", Base.NORMAL, 5),
        KARASUGOI_KOI("karasugoi_koi", Base.NORMAL, 6),
        KIGOI_KOI("kigoi_koi", Base.NORMAL, 7),
        KOHAKU_KOI("kohaku_koi", Base.NORMAL, 8),
        PLATINUM_KOI("platinum_koi", Base.NORMAL, 9),
        SHIRO_UTSURI_KOI("shiro_utsuri_koi", Base.NORMAL, 10),
        TAISHO_SANSHOKU_KOI("taisho_shanshoku_koi", Base.NORMAL, 11),
        TANCHO_KOI("tancho_koi", Base.NORMAL, 12),
        KIN_KI_UTSURI("kin_ki_utsuri_koi", Base.NORMAL, 13);

        public static final Codec<Pattern> CODEC;
        private static final IntFunction<Pattern> BY_ID;
        private final String name;
        private final Component displayName;
        private final Base base;
        private final int packedId;

        private Pattern(String pName, Base pBase, int pId) {
            this.name = pName;
            this.base = pBase;
            this.packedId = pId;
            this.displayName = Component.translatable((String)("entity.fetzisasiandeco.koi.type." + this.name));
        }

        public static Pattern byId(int pPackedId) {
            return BY_ID.apply(pPackedId);
        }

        public Base base() {
            return this.base;
        }

        public int getPackedId() {
            return this.packedId;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Component displayName() {
            return this.displayName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Pattern::values);
            BY_ID = ByIdMap.sparse(Pattern::getPackedId, (Object[])Pattern.values(), (Object)((Object)WHITE_KOI));
        }
    }

    static class KoiEntityGroupData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        final Variant variant;

        KoiEntityGroupData(KoiEntity pLeader, Variant pVariant) {
            super((AbstractSchoolingFish)pLeader);
            this.variant = pVariant;
        }
    }

    public record Variant(Pattern pattern) {
        public static final Codec<Variant> CODEC = Codec.INT.xmap(Variant::new, Variant::getPackedId);

        public Variant(int id) {
            this(KoiEntity.getPattern(id));
        }

        public int getPackedId() {
            return KoiEntity.packVariant(this.pattern);
        }
    }

    public static enum Base {
        NORMAL(0);

        final int id;

        private Base(int pId) {
            this.id = pId;
        }
    }
}

