/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.entity.custom;

import io.github.lordfetzi.init.entityInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SeatEntity
extends Entity {
    public SeatEntity(Level level) {
        super((EntityType)entityInit.SEAT.get(), level);
        this.noPhysics = true;
    }

    private SeatEntity(Level level, BlockPos source, double yOffset, Direction direction) {
        this(level);
        this.setPos((double)source.getX() + 0.5, (double)source.getY() + yOffset, (double)source.getZ() + 0.5);
        this.setRot(direction.getOpposite().toYRot(), 0.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.build();
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && (this.getPassengers().isEmpty() || this.level().isEmptyBlock(this.blockPosition()))) {
            this.remove(Entity.RemovalReason.DISCARDED);
            this.level().updateNeighbourForOutputSignal(this.blockPosition(), this.level().getBlockState(this.blockPosition()).getBlock());
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    protected boolean canRide(Entity entity) {
        return true;
    }

    public static InteractionResult create(Level level, BlockPos pos, double yOffset, Player player, Direction direction) {
        List seats;
        if (!level.isClientSide() && (seats = level.getEntitiesOfClass(SeatEntity.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 1.0))).isEmpty()) {
            SeatEntity seat = new SeatEntity(level, pos, yOffset, direction);
            level.addFreshEntity((Entity)seat);
            player.startRiding((Entity)seat, false);
        }
        return InteractionResult.SUCCESS;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity entity) {
        Direction[] offsets;
        Direction original = this.getDirection();
        for (Direction dir : offsets = new Direction[]{original, original.getClockWise(), original.getCounterClockWise(), original.getOpposite()}) {
            Vec3 safeVec = DismountHelper.findSafeDismountLocation((EntityType)entity.getType(), (CollisionGetter)this.level(), (BlockPos)this.blockPosition().relative(dir), (boolean)false);
            if (safeVec == null) continue;
            return safeVec.add(0.0, 0.25, 0.0);
        }
        return super.getDismountLocationForPassenger(entity);
    }

    protected void addPassenger(Entity entity) {
        super.addPassenger(entity);
        entity.setYRot(this.getYRot());
    }
}

