/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.items;

import com.mojang.serialization.MapCodec;
import dev.architectury.core.item.ArchitecturyMobBucketItem;
import io.github.lordfetzi.entity.custom.KoiEntity;
import io.github.lordfetzi.init.entityInit;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.material.Fluid;

public class KoiBucketItem
extends ArchitecturyMobBucketItem {
    private static final MapCodec<KoiEntity.Variant> VARIANT_FIELD_CODEC = KoiEntity.Variant.CODEC.fieldOf("KoiBucketVariantTag");
    private final Supplier<? extends EntityType<?>> type;

    public KoiBucketItem(Supplier<? extends EntityType<?>> entity, Supplier<? extends Fluid> fluid, Supplier<? extends SoundEvent> sound, Item.Properties properties) {
        super(entity, fluid, sound, properties);
        this.type = entity;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, context, pTooltipComponents, pIsAdvanced);
        if (this.type.get() == entityInit.KOI.get()) {
            CustomData customData = (CustomData)pStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            if (customData.isEmpty()) {
                return;
            }
            Optional optional = customData.read(VARIANT_FIELD_CODEC).result();
            if (optional.isPresent()) {
                KoiEntity.Variant variant = (KoiEntity.Variant)optional.get();
                ChatFormatting[] style = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
                int i = KoiEntity.COMMON_VARIANTS.indexOf(variant);
                if (i != -1) {
                    pTooltipComponents.add((Component)Component.translatable((String)KoiEntity.getPredefinedName(i)).withStyle(style));
                } else {
                    pTooltipComponents.add((Component)variant.pattern().displayName().plainCopy().withStyle(style));
                }
            }
        }
    }
}

