/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.mixin;

import io.github.lordfetzi.entity.custom.DoubleFramedBlockEntityBase;
import io.github.lordfetzi.entity.custom.FramedBlockEntityBase;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    @Shadow
    @Final
    private RegistryAccess.Frozen registryAccess;

    @Shadow
    public abstract Connection getConnection();

    @Inject(method={"lambda$handleBlockEntityData$5(Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void customBlockUpdateHandler(ClientboundBlockEntityDataPacket packet, BlockEntity blockEntity, CallbackInfo ci) {
        Connection connection = this.getConnection();
        if (blockEntity instanceof FramedBlockEntityBase) {
            FramedBlockEntityBase handler = (FramedBlockEntityBase)blockEntity;
            handler.onDataPacket(connection, packet, (HolderLookup.Provider)this.registryAccess);
            ci.cancel();
        } else if (blockEntity instanceof DoubleFramedBlockEntityBase) {
            DoubleFramedBlockEntityBase handler = (DoubleFramedBlockEntityBase)blockEntity;
            handler.onDataPacket(connection, packet, (HolderLookup.Provider)this.registryAccess);
            ci.cancel();
        }
    }
}

