/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.neoforge.entity.custom;

import io.github.lordfetzi.entity.custom.DoubleFramedBlockEntityBase;
import io.github.lordfetzi.neoforge.model.BakedDoubleFramedModelNeoForge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class DoubleFramedBlockEntityNeoForge
extends DoubleFramedBlockEntityBase {
    public DoubleFramedBlockEntityNeoForge(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(BakedDoubleFramedModelNeoForge.TEXTURE_PROPERTY_1, (Object)this.texture1).with(BakedDoubleFramedModelNeoForge.TEXTURE_PROPERTY_2, (Object)this.texture2).build();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Override
    public void setTexture1(String textureId) {
        if (this.level != null && !this.level.isClientSide) {
            try {
                this.texture1 = textureId;
                this.requestModelDataUpdate();
                this.setChanged();
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            catch (Exception e) {
                this.texture1 = "fetzisasiandeco:placeholder_frame";
            }
        }
    }

    @Override
    public void setTexture2(String textureId) {
        if (this.level != null && !this.level.isClientSide) {
            try {
                this.texture2 = textureId;
                this.requestModelDataUpdate();
                this.setChanged();
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            catch (Exception e) {
                this.texture2 = "fetzisasiandeco:placeholder_solid";
            }
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.level != null && this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

