/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.neoforge.entity.custom;

import io.github.lordfetzi.entity.custom.FramedBlockEntityBase;
import io.github.lordfetzi.neoforge.model.BakedFramedModelNeoForge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class FramedBlockEntityNeoForge
extends FramedBlockEntityBase {
    public FramedBlockEntityNeoForge(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(BakedFramedModelNeoForge.TEXTURE_PROPERTY, (Object)this.texture).build();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Override
    public void setTexture(String textureId) {
        if (this.level != null && !this.level.isClientSide) {
            try {
                this.texture = textureId;
                this.requestModelDataUpdate();
                this.setChanged();
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            catch (Exception e) {
                this.texture = "fetzisasiandeco:placeholder_frame";
            }
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.level != null && this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

