/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.neoforge.model;

import io.github.lordfetzi.neoforge.entity.custom.FramedBlockEntityNeoForge;
import io.github.lordfetzi.util.FetzisAsianDecoQuadHelper;
import io.github.lordfetzi.util.FetzisAsianDecoTextureSpriteCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedFramedModelNeoForge
implements IDynamicBakedModel {
    private final BakedModel baseModel;
    public static final ModelProperty<String> TEXTURE_PROPERTY = new ModelProperty();
    private static final int CACHE_SIZE = 64;
    private static final Map<String, List<BakedQuad>> QUAD_CACHE = new ConcurrentHashMap<String, List<BakedQuad>>();

    public BakedFramedModelNeoForge(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return List.of();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        String textureId = null;
        try {
            textureId = (String)extraData.get(TEXTURE_PROPERTY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (textureId == null) {
            return this.baseModel.getQuads(state, side, rand, extraData, renderType);
        }
        String cacheKey = BakedFramedModelNeoForge.stateKey(state) + "#" + BakedFramedModelNeoForge.renderTypeKey(renderType) + "#" + (side != null ? side.getName() : "null") + "#" + (textureId != null ? textureId : "null");
        List<BakedQuad> cached = QUAD_CACHE.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        TextureAtlasSprite newSprite = FetzisAsianDecoTextureSpriteCache.getCachedTexture(textureId);
        if (newSprite == null) {
            newSprite = FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
        }
        List originalQuads = this.baseModel.getQuads(state, side, rand, extraData, renderType);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(originalQuads.size());
        for (BakedQuad quad : originalQuads) {
            if (quad.getSprite().contents().toString().contains("placeholder") && newSprite != null) {
                BakedQuad transformedQuad = this.transformQuad(quad, newSprite);
                quads.add(transformedQuad);
                continue;
            }
            quads.add(quad);
        }
        if (QUAD_CACHE.size() < 64) {
            QUAD_CACHE.put(cacheKey, quads);
        } else if (QUAD_CACHE.size() >= 128) {
            QUAD_CACHE.clear();
        }
        return quads;
    }

    private BakedQuad transformQuad(BakedQuad quad, TextureAtlasSprite newSprite) {
        BakedQuad clonedQuad = FetzisAsianDecoQuadHelper.clone(quad);
        int[] vertexData = clonedQuad.getVertices();
        for (int vertex = 0; vertex < 4; ++vertex) {
            float u = FetzisAsianDecoQuadHelper.getU(vertexData, vertex);
            float v = FetzisAsianDecoQuadHelper.getV(vertexData, vertex);
            float unInterpolatedU = FetzisAsianDecoQuadHelper.getUnInterpolatedU(quad.getSprite(), u);
            float unInterpolatedV = FetzisAsianDecoQuadHelper.getUnInterpolatedV(quad.getSprite(), v);
            FetzisAsianDecoQuadHelper.setU(vertexData, vertex, newSprite.getU(unInterpolatedU));
            FetzisAsianDecoQuadHelper.setV(vertexData, vertex, newSprite.getV(unInterpolatedV));
        }
        return clonedQuad;
    }

    private static String stateKey(@Nullable BlockState s) {
        if (s == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(BuiltInRegistries.BLOCK.getKey((Object)s.getBlock()).toString());
        s.getValues().forEach((p, v) -> sb.append('|').append(p.getName()).append('=').append(String.valueOf(v)));
        return sb.toString();
    }

    private static String renderTypeKey(@Nullable RenderType rt) {
        return rt == null ? "null" : rt.toString();
    }

    public boolean useAmbientOcclusion() {
        return this.baseModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.baseModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.baseModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.baseModel.isCustomRenderer();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.baseModel.getParticleIcon();
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return this.baseModel.getTransforms();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return this.baseModel.getOverrides();
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntityNeoForge) {
            FramedBlockEntityNeoForge framedBlockEntity = (FramedBlockEntityNeoForge)blockEntity;
            return framedBlockEntity.getModelData();
        }
        return modelData;
    }

    public static void clearCache() {
        QUAD_CACHE.clear();
    }
}

