/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FetzisAsianDecoTextureSpriteCache {
    private static final Map<String, CachedSprite> TEXTURE_CACHE = new ConcurrentHashMap<String, CachedSprite>();
    private static final Map<String, TextureAtlasSprite> BLOCK_TEXTURE_CACHE = new ConcurrentHashMap<String, TextureAtlasSprite>();
    private static final long CACHE_EXPIRY_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final int MAX_CACHE_SIZE = 256;
    private static long lastCleanup = System.currentTimeMillis();

    public static TextureAtlasSprite getCachedTexture(String textureId) {
        if (textureId == null) {
            return null;
        }
        FetzisAsianDecoTextureSpriteCache.cleanupIfNeeded();
        CachedSprite cached = TEXTURE_CACHE.get(textureId);
        if (cached != null && !cached.isExpired()) {
            return cached.sprite;
        }
        TextureAtlasSprite sprite = FetzisAsianDecoTextureSpriteCache.loadTexture(textureId);
        if (sprite != null) {
            TEXTURE_CACHE.put(textureId, new CachedSprite(sprite));
        }
        return sprite;
    }

    private static TextureAtlasSprite loadTexture(String textureId) {
        try {
            String[] values = textureId.split(":");
            if (values.length != 2) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)values[0], (String)("block/" + values[1]));
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
            if (sprite.contents().name().toString().contains("missingno")) {
                return FetzisAsianDecoTextureSpriteCache.getFirstTextureFromBlock(textureId);
            }
            return sprite;
        }
        catch (Exception e) {
            System.err.println("[Fetzi's Asian Deco] Error loading texture: " + textureId);
            return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
        }
    }

    public static TextureAtlasSprite getFirstTextureFromBlock(String blockId) {
        TextureAtlasSprite cached = BLOCK_TEXTURE_CACHE.get(blockId);
        if (cached != null) {
            return cached;
        }
        try {
            TextureAtlasSprite sprite;
            String[] values = blockId.split(":");
            if (values.length != 2) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            ResourceLocation blockResource = ResourceLocation.fromNamespaceAndPath((String)values[0], (String)values[1]);
            Block block = (Block)BuiltInRegistries.BLOCK.get(blockResource);
            if (block == null || block.defaultBlockState() == null) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            BlockState defaultState = block.defaultBlockState();
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(defaultState);
            for (Direction direction : Direction.values()) {
                TextureAtlasSprite sprite2;
                List quads = model.getQuads(defaultState, direction, RandomSource.create());
                if (quads.isEmpty() || quads.get(0) == null || (sprite2 = ((BakedQuad)quads.get(0)).getSprite()) == null) continue;
                BLOCK_TEXTURE_CACHE.put(blockId, sprite2);
                return sprite2;
            }
            List generalQuads = model.getQuads(defaultState, null, RandomSource.create());
            if (!generalQuads.isEmpty() && generalQuads.get(0) != null && (sprite = ((BakedQuad)generalQuads.get(0)).getSprite()) != null) {
                BLOCK_TEXTURE_CACHE.put(blockId, sprite);
                return sprite;
            }
        }
        catch (Exception e) {
            System.err.println("[Fetzi's Asian Deco] Error extracting texture from block: " + blockId);
        }
        return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
    }

    public static TextureAtlasSprite getPlaceholderSprite() {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(ResourceLocation.fromNamespaceAndPath((String)"fetzisasiandeco", (String)"block/placeholder_frame"));
    }

    public static TextureAtlasSprite getPlaceholderSolidSprite() {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(ResourceLocation.fromNamespaceAndPath((String)"fetzisasiandeco", (String)"block/placeholder_solid"));
    }

    private static void cleanupIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - lastCleanup < 30000L) {
            return;
        }
        lastCleanup = now;
        TEXTURE_CACHE.entrySet().removeIf(entry -> ((CachedSprite)entry.getValue()).isExpired());
        if (TEXTURE_CACHE.size() > 256) {
            TEXTURE_CACHE.entrySet().stream().sorted((e1, e2) -> Long.compare(((CachedSprite)e1.getValue()).timestamp, ((CachedSprite)e2.getValue()).timestamp)).limit(TEXTURE_CACHE.size() - 256).forEach(entry -> TEXTURE_CACHE.remove(entry.getKey()));
        }
        if (BLOCK_TEXTURE_CACHE.size() > 256) {
            BLOCK_TEXTURE_CACHE.clear();
        }
    }

    public static void clearCaches() {
        TEXTURE_CACHE.clear();
        BLOCK_TEXTURE_CACHE.clear();
        lastCleanup = System.currentTimeMillis();
    }

    private static class CachedSprite {
        final TextureAtlasSprite sprite;
        final long timestamp;

        CachedSprite(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > CACHE_EXPIRY_MS;
        }
    }
}

