/*
 * Decompiled with CFR 0.152.
 */
package io.github.lordfetzi.fabric.model;

import io.github.lordfetzi.fabric.entity.custom.FramedBlockEntityFabric;
import io.github.lordfetzi.util.FetzisAsianDecoQuadHelper;
import io.github.lordfetzi.util.FetzisAsianDecoTextureSpriteCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BakedFramedModelFabric
implements FabricBakedModel,
class_1087 {
    private final class_1087 baseCubeModel;
    private static final int CACHE_SIZE = 64;
    private static final Map<String, List<class_777>> QUAD_CACHE = new ConcurrentHashMap<String, List<class_777>>();

    public BakedFramedModelFabric(class_1087 baseCubeModel) {
        this.baseCubeModel = baseCubeModel;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2586 entity = blockView.method_8321(pos);
        if (entity instanceof FramedBlockEntityFabric) {
            FramedBlockEntityFabric framedEntity = (FramedBlockEntityFabric)entity;
            String textureId = framedEntity.getTexture();
            if (textureId == null) {
                this.emitDefaultQuads(state, randomSupplier, context);
                return;
            }
            String cacheKey = BakedFramedModelFabric.stateKey(state) + "#" + (textureId != null ? textureId : "null");
            List<class_777> cachedQuads = QUAD_CACHE.get(cacheKey);
            if (cachedQuads != null) {
                for (class_777 quad : cachedQuads) {
                    QuadEmitter emitter = context.getEmitter();
                    emitter.fromVanilla(quad, context.getEmitter().material(), null);
                    emitter.emit();
                }
                return;
            }
            class_1058 newSprite = FetzisAsianDecoTextureSpriteCache.getCachedTexture(textureId);
            if (newSprite == null) {
                newSprite = FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            List originalQuads = this.baseCubeModel.method_4707(state, null, randomSupplier.get());
            ArrayList<class_777> transformedQuads = new ArrayList<class_777>(originalQuads.size());
            for (class_777 quad : originalQuads) {
                if (quad.method_35788().method_45851().toString().contains("placeholder") && newSprite != null) {
                    class_777 transformedQuad = this.transformQuad(quad, newSprite);
                    transformedQuads.add(transformedQuad);
                    continue;
                }
                transformedQuads.add(quad);
            }
            if (QUAD_CACHE.size() < 64) {
                QUAD_CACHE.put(cacheKey, transformedQuads);
            } else if (QUAD_CACHE.size() >= 128) {
                QUAD_CACHE.clear();
            }
            for (class_777 quad : transformedQuads) {
                QuadEmitter emitter = context.getEmitter();
                emitter.fromVanilla(quad, context.getEmitter().material(), null);
                emitter.emit();
            }
        } else {
            this.baseCubeModel.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }
    }

    private void emitDefaultQuads(class_2680 state, Supplier<class_5819> randomSupplier, RenderContext context) {
        List quads = this.baseCubeModel.method_4707(state, null, randomSupplier.get());
        for (class_777 quad : quads) {
            QuadEmitter emitter = context.getEmitter();
            emitter.fromVanilla(quad, context.getEmitter().material(), null);
            emitter.emit();
        }
    }

    private class_777 transformQuad(class_777 quad, class_1058 newSprite) {
        class_777 clonedQuad = FetzisAsianDecoQuadHelper.clone(quad);
        int[] vertexData = clonedQuad.method_3357();
        for (int vertex = 0; vertex < 4; ++vertex) {
            float u = FetzisAsianDecoQuadHelper.getU(vertexData, vertex);
            float v = FetzisAsianDecoQuadHelper.getV(vertexData, vertex);
            float unInterpolatedU = FetzisAsianDecoQuadHelper.getUnInterpolatedU(quad.method_35788(), u);
            float unInterpolatedV = FetzisAsianDecoQuadHelper.getUnInterpolatedV(quad.method_35788(), v);
            FetzisAsianDecoQuadHelper.setU(vertexData, vertex, newSprite.method_4580(unInterpolatedU));
            FetzisAsianDecoQuadHelper.setV(vertexData, vertex, newSprite.method_4570(unInterpolatedV));
        }
        return clonedQuad;
    }

    private static String stateKey(@Nullable class_2680 s) {
        if (s == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(class_7923.field_41175.method_10221((Object)s.method_26204()).toString());
        s.method_11656().forEach((p, v) -> sb.append('|').append(p.method_11899()).append('=').append(String.valueOf(v)));
        return sb.toString();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
        return List.of();
    }

    public boolean method_4708() {
        return this.baseCubeModel.method_4708();
    }

    public boolean method_4712() {
        return this.baseCubeModel.method_4712();
    }

    public boolean method_24304() {
        return this.baseCubeModel.method_24304();
    }

    public boolean method_4713() {
        return this.baseCubeModel.method_4713();
    }

    @NotNull
    public class_1058 method_4711() {
        return this.baseCubeModel.method_4711();
    }

    @NotNull
    public class_809 method_4709() {
        return this.baseCubeModel.method_4709();
    }

    @NotNull
    public class_806 method_4710() {
        return this.baseCubeModel.method_4710();
    }

    public static void clearCache() {
        QUAD_CACHE.clear();
    }
}

