/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.blocks.FramedBlocks;

import io.github.leonard1504.blocks.ShojiWall;
import io.github.leonard1504.blocks.SlidingDoors;
import io.github.leonard1504.blocks.SlidingTrapdoors;
import io.github.leonard1504.entity.custom.DoubleFramedBlockEntityBase;
import io.github.leonard1504.entity.custom.DoubleFramedBlockEntityFactory;
import io.github.leonard1504.property.BeamVerticalProperty;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BeamBlockFramedBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BeamVerticalProperty BEAM_VERTICAL_PROPERTY = BeamVerticalProperty.create("vertical_type");
    public final VoxelShape SHAPE = Shapes.m_83144_();

    public BeamBlockFramedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BEAM_VERTICAL_PROPERTY, (Comparable)((Object)"none")));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH}).m_61104_(new Property[]{EAST}).m_61104_(new Property[]{SOUTH}).m_61104_(new Property[]{WEST}).m_61104_(new Property[]{UP}).m_61104_(new Property[]{DOWN}).m_61104_(new Property[]{BEAM_VERTICAL_PROPERTY});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = this.isBeam(level, pos, Direction.NORTH);
        boolean east = this.isBeam(level, pos, Direction.EAST);
        boolean south = this.isBeam(level, pos, Direction.SOUTH);
        boolean west = this.isBeam(level, pos, Direction.WEST);
        boolean up = this.isBeam(level, pos, Direction.UP);
        boolean down = this.isBeam(level, pos, Direction.DOWN);
        String verticalType = "none";
        if (up || down && !north && !east && !south && !west) {
            verticalType = this.hasBlockNeighbour(level, pos);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)BEAM_VERTICAL_PROPERTY, (Comparable)((Object)verticalType));
    }

    private boolean isBeam(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        boolean connectable = false;
        if (state.m_60734_() instanceof BeamBlockFramedBlock) {
            connectable = true;
        }
        return connectable;
    }

    private String hasBlockNeighbour(LevelAccessor level, BlockPos source) {
        String verticalType = "none";
        int matchCount = 0;
        boolean north = false;
        boolean east = false;
        boolean south = false;
        boolean west = false;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState neighbourState = level.m_8055_(source.m_121945_(dir));
            if (neighbourState.m_60795_() || neighbourState.m_60734_() instanceof ShojiWall || neighbourState.m_60734_() instanceof SlidingDoors || neighbourState.m_60734_() instanceof SlidingTrapdoors) continue;
            ++matchCount;
            switch (dir) {
                case NORTH: {
                    north = true;
                    break;
                }
                case EAST: {
                    east = true;
                    break;
                }
                case SOUTH: {
                    south = true;
                    break;
                }
                case WEST: {
                    west = true;
                }
            }
        }
        if (north && east) {
            verticalType = "corner_ne";
        } else if (east && south) {
            verticalType = "corner_se";
        } else if (south && west) {
            verticalType = "corner_sw";
        } else if (west && north) {
            verticalType = "corner_nw";
        } else if (matchCount == 1) {
            if (north) {
                verticalType = "south";
            }
            if (east) {
                verticalType = "west";
            }
            if (south) {
                verticalType = "north";
            }
            if (west) {
                verticalType = "east";
            }
        } else if (matchCount > 1) {
            verticalType = "none";
        }
        return verticalType;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item;
        ItemStack heldItem = player.m_21120_(hand);
        if (!world.f_46443_ && (item = heldItem.m_41720_()) instanceof BlockItem) {
            DoubleFramedBlockEntityBase framedBlockEntity;
            BlockItem blockItem = (BlockItem)item;
            if (blockItem.m_40614_().arch$registryName().m_135827_().equals("fetzisasiandeco") && (blockItem.m_40614_().arch$registryName().toString().contains("framed_block") || blockItem.m_40614_().arch$registryName().toString().contains("framed_double_block"))) {
                return InteractionResult.PASS;
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof DoubleFramedBlockEntityBase && !(framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity).hasTexture1()) {
                framedBlockEntity.setTexture1(blockItem.m_40614_().arch$registryName().toString());
                framedBlockEntity.m_6596_();
                world.m_7260_(pos, state, state, 3);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                world.m_5594_(null, pos, blockItem.m_40614_().m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof DoubleFramedBlockEntityBase && !(framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity).hasTexture2()) {
                framedBlockEntity.setTexture2(blockItem.m_40614_().arch$registryName().toString());
                framedBlockEntity.m_6596_();
                world.m_7260_(pos, state, state, 3);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                world.m_5594_(null, pos, blockItem.m_40614_().m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof DoubleFramedBlockEntityBase) {
            DoubleFramedBlockEntityBase framedBlockEntity = (DoubleFramedBlockEntityBase)blockEntity;
            if (!player.m_7500_()) {
                ResourceLocation resourceLocation;
                Block textureBlock;
                String textureId2;
                ResourceLocation resourceLocation2;
                Block textureBlock2;
                String textureId1 = framedBlockEntity.getTexture1();
                if (textureId1 != null && (textureBlock2 = (Block)BuiltInRegistries.f_256975_.m_7745_(resourceLocation2 = new ResourceLocation(textureId1))) != Blocks.f_50016_) {
                    ItemStack dropStack = new ItemStack((ItemLike)textureBlock2);
                    BeamBlockFramedBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)dropStack);
                }
                if ((textureId2 = framedBlockEntity.getTexture2()) != null && (textureBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(resourceLocation = new ResourceLocation(textureId2))) != Blocks.f_50016_) {
                    ItemStack dropStack = new ItemStack((ItemLike)textureBlock);
                    BeamBlockFramedBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)dropStack);
                }
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = world.m_7702_(pos)) instanceof DoubleFramedBlockEntityBase) {
            world.m_46747_(pos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> m_142354_(Level level, BlockState state, BlockEntityType<S> bet) {
        return null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return DoubleFramedBlockEntityFactory.create(pos, state);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisasiandeco.shift_2"));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisasiandeco.framed_double_block.detailed_1"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisasiandeco.framed_double_block.detailed_2"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisasiandeco.shift_1"));
        }
    }
}

