/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.blocks;

import io.github.leonard1504.config.FetzisAsianDecoConfig;
import io.github.leonard1504.entity.custom.GongBlockEntity;
import io.github.leonard1504.init.blockEntityInit;
import io.github.leonard1504.init.soundsInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Gong
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<BellAttachType> ATTACHMENT = EnumProperty.m_61587_((String)"attachment", BellAttachType.class);
    public final VoxelShape NORTH_SOUTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625);
    public final VoxelShape WEST_EAST = Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0);
    public static VoxelShape SHAPE = Shapes.m_83040_();

    public Gong(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GongBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeForAttachment(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeForAttachment(state);
    }

    private VoxelShape getShapeForAttachment(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BellAttachType attachment = (BellAttachType)state.m_61143_(ATTACHMENT);
        if (attachment == BellAttachType.SINGLE_WALL || attachment == BellAttachType.DOUBLE_WALL) {
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return this.NORTH_SOUTH;
            }
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return this.WEST_EAST;
            }
        }
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return this.NORTH_SOUTH;
        }
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return this.WEST_EAST;
        }
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            if (this.validSide(state, hit)) {
                gongBlockEntity.startRinging(hit.m_82434_());
                this.playRandomGongSound(level, pos);
                this.attractMobs(level, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean validSide(BlockState state, BlockHitResult hit) {
        return state.m_61143_(ATTACHMENT) == BellAttachType.FLOOR || state.m_61143_(ATTACHMENT) == BellAttachType.CEILING ? hit.m_82434_() == state.m_61143_((Property)FACING) || hit.m_82434_() == ((Direction)state.m_61143_((Property)FACING)).m_122424_() : hit.m_82434_() != state.m_61143_((Property)FACING) || hit.m_82434_() != ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos = hit.m_82425_())) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            Direction hitDirection = hit.m_82434_();
            gongBlockEntity.startRinging(hitDirection);
            this.playRandomGongSound(level, pos);
            this.attractMobs(level, pos);
        }
    }

    private void playRandomGongSound(Level level, BlockPos pos) {
        if (level.f_46441_.m_188499_()) {
            level.m_5594_(null, pos, (SoundEvent)soundsInit.GONG_1.get(), SoundSource.BLOCKS, 1.0f, this.getRandomPitch(level));
        } else {
            level.m_5594_(null, pos, (SoundEvent)soundsInit.GONG_2.get(), SoundSource.BLOCKS, 1.0f, this.getRandomPitch(level));
        }
    }

    private float getRandomPitch(Level level) {
        return 0.7f + level.f_46441_.m_188501_() * 0.3f;
    }

    private void attractMobs(Level level, BlockPos gongPos) {
        int radius = FetzisAsianDecoConfig.getGongAttractRange();
        List mobs = level.m_6443_(LivingEntity.class, new AABB(gongPos).m_82400_((double)radius), mob -> mob.m_6095_() == EntityType.f_20492_);
        for (LivingEntity mob2 : mobs) {
            if (!(mob2 instanceof PathfinderMob)) continue;
            PathfinderMob pathfindingMob = (PathfinderMob)mob2;
            pathfindingMob.m_21573_().m_26519_((double)gongPos.m_123341_() + 0.5, (double)gongPos.m_123342_() + 0.5, (double)gongPos.m_123343_() + 0.5, 1.0);
        }
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        GongBlockEntity gongBlockEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GongBlockEntity && (gongBlockEntity = (GongBlockEntity)blockEntity).isRinging()) {
            return (int)Math.ceil((1.0 - (double)gongBlockEntity.getRingingTicks() / 100.0) * 15.0);
        }
        return 0;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        BlockEntity blockEntity;
        boolean powered;
        if (!level.f_46443_ && (powered = level.m_276867_(pos)) && (blockEntity = level.m_7702_(pos)) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            gongBlockEntity.startRinging(Direction.NORTH);
            this.playRandomGongSound(level, pos);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ATTACHMENT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        Direction.Axis axis = direction.m_122434_();
        if (axis == Direction.Axis.Y) {
            BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_());
            if (blockState.m_60710_((LevelReader)context.m_43725_(), blockPos)) {
                return blockState;
            }
        } else {
            boolean bl = axis == Direction.Axis.X && level.m_8055_(blockPos.m_122024_()).m_60783_((BlockGetter)level, blockPos.m_122024_(), Direction.EAST) && level.m_8055_(blockPos.m_122029_()).m_60783_((BlockGetter)level, blockPos.m_122029_(), Direction.WEST) || axis == Direction.Axis.Z && level.m_8055_(blockPos.m_122012_()).m_60783_((BlockGetter)level, blockPos.m_122012_(), Direction.SOUTH) && level.m_8055_(blockPos.m_122019_()).m_60783_((BlockGetter)level, blockPos.m_122019_(), Direction.NORTH);
            BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_(ATTACHMENT, (Comparable)(bl ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL));
            if (blockState.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
                return blockState;
            }
            boolean bl2 = level.m_8055_(blockPos.m_7495_()).m_60783_((BlockGetter)level, blockPos.m_7495_(), Direction.UP);
            if ((blockState = (BlockState)blockState.m_61124_(ATTACHMENT, (Comparable)(bl2 ? BellAttachType.FLOOR : BellAttachType.CEILING))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
                return blockState;
            }
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BellAttachType bellAttachType = (BellAttachType)state.m_61143_(ATTACHMENT);
        Direction direction2 = Gong.getConnectedDirection(state).m_122424_();
        if (direction2 == direction && !state.m_60710_((LevelReader)level, pos) && bellAttachType != BellAttachType.DOUBLE_WALL) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            if (bellAttachType == BellAttachType.DOUBLE_WALL && !neighborState.m_60783_((BlockGetter)level, neighborPos, direction)) {
                return (BlockState)((BlockState)state.m_61124_(ATTACHMENT, (Comparable)BellAttachType.SINGLE_WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            }
            if (bellAttachType == BellAttachType.SINGLE_WALL && direction2.m_122424_() == direction && neighborState.m_60783_((BlockGetter)level, neighborPos, (Direction)state.m_61143_((Property)FACING))) {
                return (BlockState)state.m_61124_(ATTACHMENT, (Comparable)BellAttachType.DOUBLE_WALL);
            }
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    private static Direction getConnectedDirection(BlockState state) {
        switch ((BellAttachType)state.m_61143_(ATTACHMENT)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == blockEntityInit.GONG_ENTITY_TYPE.get()) {
            return (lvl, pos, blockState, blockEntity) -> {
                if (blockEntity instanceof GongBlockEntity) {
                    GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
                    GongBlockEntity.tick(lvl, pos, blockState, gongBlockEntity);
                }
            };
        }
        return null;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisasiandeco.shift_2"));
            tooltip.add((Component)Component.m_237119_());
            MutableComponent rangeValue = Component.m_237113_((String)String.valueOf(FetzisAsianDecoConfig.getGongAttractRange())).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.fetzisasiandeco.gong", (Object[])new Object[]{rangeValue}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.fetzisasiandeco.shift_1"));
        }
    }
}

