/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.leonard1504.blocks.Gong;
import io.github.leonard1504.entity.custom.GongBlockEntity;
import io.github.leonard1504.init.blockInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GongBlockRenderer
implements BlockEntityRenderer<GongBlockEntity> {
    public GongBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(GongBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        float rotationY;
        poseStack.m_85836_();
        BlockState state = blockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)Gong.FACING);
        BellAttachType attachment = (BellAttachType)state.m_61143_(Gong.ATTACHMENT);
        if (attachment == BellAttachType.SINGLE_WALL || attachment == BellAttachType.DOUBLE_WALL) {
            rotationY = switch (facing) {
                case Direction.NORTH -> 90.0f;
                case Direction.SOUTH -> 90.0f;
                case Direction.EAST -> 0.0f;
                case Direction.WEST -> 0.0f;
                default -> 0.0f;
            };
        } else {
            rotationY = switch (facing) {
                case Direction.NORTH -> 0.0f;
                case Direction.SOUTH -> 0.0f;
                case Direction.EAST -> 90.0f;
                case Direction.WEST -> 90.0f;
                default -> 0.0f;
            };
        }
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationY));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        poseStack.m_85837_(0.5, 0.95, 0.5);
        if (blockEntity.isRinging()) {
            float progress = ((float)blockEntity.getRingingTicks() + partialTicks) / 100.0f;
            int swingCycles = 5;
            float angle = (float)Math.sin((double)progress * Math.PI * 2.0 * (double)swingCycles) * (25.0f * (1.0f - progress));
            Axis rotationAxis = this.getRotationAxis(blockEntity.getRingDirection());
            poseStack.m_252781_(rotationAxis.m_252977_(angle));
        }
        poseStack.m_85837_(-0.5, -0.95, -0.5);
        Minecraft.m_91087_().m_91289_().m_110912_(((Block)blockInit.GONG.get()).m_49966_(), poseStack, buffer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    private Axis getRotationAxis(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Axis.f_252495_;
            case Direction.SOUTH -> Axis.f_252529_;
            case Direction.WEST -> Axis.f_252495_;
            case Direction.EAST -> Axis.f_252529_;
            case Direction.UP -> Axis.f_252495_;
            case Direction.DOWN -> Axis.f_252529_;
        };
    }
}

