/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.entity.custom;

import io.github.leonard1504.init.blockEntityInit;
import io.github.leonard1504.util.TextureStringCache;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleFramedBlockEntityBase
extends BlockEntity {
    protected String texture1;
    protected String texture2;
    private ResourceLocation cachedTexture1Location;
    private ResourceLocation cachedTexture2Location;

    public DoubleFramedBlockEntityBase(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.DOUBLE_FRAMED_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public String getTexture1() {
        return this.texture1;
    }

    public String getTexture2() {
        return this.texture2;
    }

    public boolean hasTexture1() {
        return this.texture1 != null;
    }

    public boolean hasTexture2() {
        return this.texture2 != null;
    }

    public void setTexture1(String textureId) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (Objects.equals(this.texture1, textureId)) {
                return;
            }
            try {
                this.texture1 = textureId != null ? TextureStringCache.getOrCache(textureId) : null;
                this.cachedTexture1Location = null;
                this.m_6596_();
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_7726_().m_8450_(this.m_58899_());
                }
                this.redraw();
            }
            catch (Exception e) {
                this.texture1 = TextureStringCache.getOrCache("fetzisasiandeco:placeholder_frame");
                this.cachedTexture1Location = null;
            }
        }
    }

    public void setTexture2(String textureId) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (Objects.equals(this.texture2, textureId)) {
                return;
            }
            try {
                this.texture2 = textureId != null ? TextureStringCache.getOrCache(textureId) : null;
                this.cachedTexture2Location = null;
                this.m_6596_();
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_7726_().m_8450_(this.m_58899_());
                }
                this.redraw();
            }
            catch (Exception e) {
                this.texture2 = TextureStringCache.getOrCache("fetzisasiandeco:placeholder_solid");
                this.cachedTexture2Location = null;
            }
        }
    }

    private void redraw() {
        if (this.m_58898_() && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 10);
            if (this.m_58900_().m_60791_() > 0) {
                this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
            }
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.texture1 != null) {
            tag.m_128359_("t1", this.texture1);
        }
        if (this.texture2 != null) {
            tag.m_128359_("t2", this.texture2);
        }
    }

    public void m_142466_(CompoundTag tag) {
        String loadedTexture;
        super.m_142466_(tag);
        if (tag.m_128441_("t1")) {
            loadedTexture = tag.m_128461_("t1");
            this.texture1 = TextureStringCache.getOrCache(loadedTexture);
            this.cachedTexture1Location = null;
        } else if (tag.m_128441_("texture1")) {
            loadedTexture = tag.m_128461_("texture1");
            this.texture1 = TextureStringCache.getOrCache(loadedTexture);
            this.cachedTexture1Location = null;
        }
        if (tag.m_128441_("t2")) {
            loadedTexture = tag.m_128461_("t2");
            this.texture2 = TextureStringCache.getOrCache(loadedTexture);
            this.cachedTexture2Location = null;
        } else if (tag.m_128441_("texture2")) {
            loadedTexture = tag.m_128461_("texture2");
            this.texture2 = TextureStringCache.getOrCache(loadedTexture);
            this.cachedTexture2Location = null;
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        if (this.texture1 != null) {
            tag.m_128359_("t1", this.texture1);
        }
        if (this.texture2 != null) {
            tag.m_128359_("t2", this.texture2);
        }
        return tag;
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null && (tag.m_128441_("t1") || tag.m_128441_("t2"))) {
            this.updateBlockAppearance(tag);
        }
    }

    public void updateBlockAppearance(CompoundTag tag) {
        if (tag != null) {
            String oldTexture1 = this.texture1;
            String oldTexture2 = this.texture2;
            this.m_142466_(tag);
            if (!Objects.equals(oldTexture1, this.texture1) || !Objects.equals(oldTexture2, this.texture2)) {
                this.redraw();
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_7651_() {
        super.m_7651_();
        this.cachedTexture1Location = null;
        this.cachedTexture2Location = null;
    }
}

