/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.entity.custom;

import io.github.leonard1504.init.blockEntityInit;
import io.github.leonard1504.util.TextureStringCache;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FramedBlockEntityBase
extends BlockEntity {
    protected String texture;

    public FramedBlockEntityBase(BlockPos pos, BlockState state) {
        super((BlockEntityType)blockEntityInit.FRAMED_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public String getTexture() {
        return this.texture;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void setTexture(String textureId) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (Objects.equals(this.texture, textureId)) {
                return;
            }
            try {
                this.texture = textureId != null ? TextureStringCache.getOrCache(textureId) : null;
                this.m_6596_();
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_7726_().m_8450_(this.m_58899_());
                }
                this.redraw();
            }
            catch (Exception e) {
                this.texture = TextureStringCache.getOrCache("fetzisasiandeco:placeholder_frame");
            }
        }
    }

    private void redraw() {
        if (this.m_58898_() && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 10);
            if (this.m_58900_().m_60791_() > 0) {
                this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.texture != null) {
            tag.m_128359_("t", this.texture);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("t")) {
            String loadedTexture = tag.m_128461_("t");
            this.texture = TextureStringCache.getOrCache(loadedTexture);
        } else if (tag.m_128441_("texture")) {
            String loadedTexture = tag.m_128461_("texture");
            this.texture = TextureStringCache.getOrCache(loadedTexture);
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        if (this.texture != null) {
            tag.m_128359_("t", this.texture);
        }
        return tag;
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null && tag.m_128441_("t")) {
            this.updateBlockAppearance(tag);
        }
    }

    public void updateBlockAppearance(CompoundTag tag) {
        if (tag != null) {
            String oldTexture = this.texture;
            this.m_142466_(tag);
            if (!Objects.equals(oldTexture, this.texture)) {
                this.redraw();
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_7651_() {
        super.m_7651_();
    }
}

