/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.entity.custom;

import dev.architectury.platform.Platform;
import io.github.leonard1504.entity.custom.FramedBlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class FramedBlockEntityFactory {
    public static FramedBlockEntityBase create(BlockPos pos, BlockState state) {
        String className;
        if (Platform.isFabric()) {
            className = "io.github.leonard1504.fabric.entity.custom.FramedBlockEntityFabric";
        } else if (Platform.isForge()) {
            className = "io.github.leonard1504.forge.entity.custom.FramedBlockEntityForge";
        } else {
            throw new IllegalStateException("Unsupported platform");
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (FramedBlockEntityBase)((Object)clazz.getConstructor(BlockPos.class, BlockState.class).newInstance(pos, state));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create FramedBlockEntity", e);
        }
    }
}

