/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.entity.custom;

import com.mojang.serialization.Codec;
import io.github.leonard1504.init.itemInit;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class KoiEntity
extends AbstractSchoolingFish
implements VariantHolder<Pattern> {
    public static final String KOI_BUCKET_VARIANT_TAG = "KoiBucketVariantTag";
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(KoiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final List<Variant> COMMON_VARIANTS = List.of(new Variant(Pattern.WHITE_KOI), new Variant(Pattern.ORANGE_KOI), new Variant(Pattern.AKA_MATSUBA_KOI), new Variant(Pattern.ASAGI_KOI), new Variant(Pattern.BEKKO_KOI), new Variant(Pattern.BENIGOI_KOI), new Variant(Pattern.KARASUGOI_KOI), new Variant(Pattern.KIGOI_KOI), new Variant(Pattern.KOHAKU_KOI), new Variant(Pattern.PLATINUM_KOI), new Variant(Pattern.SHIRO_UTSURI_KOI), new Variant(Pattern.TAISHO_SANSHOKU_KOI), new Variant(Pattern.TANCHO_KOI), new Variant(Pattern.KIN_KI_UTSURI));
    private boolean isSchool = true;
    public final AnimationState swimmingAnimationState = new AnimationState();
    public final AnimationState flopAnimationState = new AnimationState();

    public int m_6031_() {
        return 5;
    }

    public KoiEntity(EntityType<? extends KoiEntity> entityType, Level level) {
        super(entityType, level);
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        BlockPos blockpos = this.m_20183_();
        FluidState fluidstate = world.m_6425_(blockpos);
        return fluidstate.m_192917_((Fluid)Fluids.f_76193_) && fluidstate.m_76186_() == 8;
    }

    public static String getPredefinedName(int pVariantId) {
        return "entity.fetzisasiandeco.koi.predefined." + pVariantId;
    }

    static int packVariant(Pattern pPattern) {
        return pPattern.getPackedId();
    }

    public static Pattern getPattern(int pVariantId) {
        return Pattern.byId(pVariantId);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getPackedVariant());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setPackedVariant(pCompound.m_128451_("Variant"));
    }

    private void setPackedVariant(int pPackedVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pPackedVariant);
    }

    public boolean m_7296_(int pSize) {
        return !this.isSchool;
    }

    private int getPackedVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public Pattern getVariant() {
        return KoiEntity.getPattern(this.getPackedVariant());
    }

    public void setVariant(Pattern pVariant) {
        int i = this.getPackedVariant();
        this.setPackedVariant(KoiEntity.packVariant(pVariant));
    }

    public void m_6872_(ItemStack pStack) {
        super.m_6872_(pStack);
        CompoundTag compoundtag = pStack.m_41784_();
        compoundtag.m_128405_(KOI_BUCKET_VARIANT_TAG, this.getPackedVariant());
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)itemInit.KOI_FISH_BUCKET.get());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        Variant tropicalfish$variant;
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_(KOI_BUCKET_VARIANT_TAG, 3)) {
            this.setPackedVariant(pDataTag.m_128451_(KOI_BUCKET_VARIANT_TAG));
            return pSpawnData;
        }
        RandomSource randomsource = pLevel.m_213780_();
        if (pSpawnData instanceof KoiEntityGroupData) {
            KoiEntityGroupData koi$koigroupdata = (KoiEntityGroupData)((Object)pSpawnData);
            tropicalfish$variant = koi$koigroupdata.variant;
        } else if ((double)randomsource.m_188501_() < 0.9) {
            tropicalfish$variant = (Variant)Util.m_214621_(COMMON_VARIANTS, (RandomSource)randomsource);
            pSpawnData = new KoiEntityGroupData(this, tropicalfish$variant);
        } else {
            this.isSchool = false;
            Pattern[] akoi$pattern = Pattern.values();
            Pattern koi$pattern = (Pattern)((Object)Util.m_214670_((Object[])akoi$pattern, (RandomSource)randomsource));
            tropicalfish$variant = new Variant(koi$pattern);
        }
        this.setPackedVariant(tropicalfish$variant.getPackedId());
        return pSpawnData;
    }

    public void swimAnimation() {
        this.flopAnimationState.m_216973_();
        this.swimmingAnimationState.m_216977_(20);
    }

    public void flopAnimation() {
        this.swimmingAnimationState.m_216973_();
        this.flopAnimationState.m_216977_(20);
    }

    private void setupAnimationStates() {
        if (this.m_20069_()) {
            this.swimAnimation();
        } else if (this.m_20096_() && !this.m_20069_()) {
            this.flopAnimation();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.m_9236_().m_5776_()) {
            this.swimmingAnimationState.m_216973_();
            this.flopAnimationState.m_216973_();
        }
        super.m_142687_(reason);
    }

    public static enum Pattern implements StringRepresentable
    {
        WHITE_KOI("white_koi", Base.NORMAL, 0),
        ORANGE_KOI("orange_koi", Base.NORMAL, 1),
        AKA_MATSUBA_KOI("aka_matsuba_koi", Base.NORMAL, 2),
        ASAGI_KOI("asagi_koi", Base.NORMAL, 3),
        BEKKO_KOI("bekko_koi", Base.NORMAL, 4),
        BENIGOI_KOI("benigoi_koi", Base.NORMAL, 5),
        KARASUGOI_KOI("karasugoi_koi", Base.NORMAL, 6),
        KIGOI_KOI("kigoi_koi", Base.NORMAL, 7),
        KOHAKU_KOI("kohaku_koi", Base.NORMAL, 8),
        PLATINUM_KOI("platinum_koi", Base.NORMAL, 9),
        SHIRO_UTSURI_KOI("shiro_utsuri_koi", Base.NORMAL, 10),
        TAISHO_SANSHOKU_KOI("taisho_shanshoku_koi", Base.NORMAL, 11),
        TANCHO_KOI("tancho_koi", Base.NORMAL, 12),
        KIN_KI_UTSURI("kin_ki_utsuri_koi", Base.NORMAL, 13);

        public static final Codec<Pattern> CODEC;
        private static final IntFunction<Pattern> BY_ID;
        private final String name;
        private final Component displayName;
        private final Base base;
        private final int packedId;

        private Pattern(String pName, Base pBase, int pId) {
            this.name = pName;
            this.base = pBase;
            this.packedId = pId;
            this.displayName = Component.m_237115_((String)("entity.fetzisasiandeco.koi.type." + this.name));
        }

        public static Pattern byId(int pPackedId) {
            return BY_ID.apply(pPackedId);
        }

        public Base base() {
            return this.base;
        }

        public int getPackedId() {
            return this.packedId;
        }

        public String m_7912_() {
            return this.name;
        }

        public Component displayName() {
            return this.displayName;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Pattern::values);
            BY_ID = ByIdMap.m_262845_(Pattern::getPackedId, (Object[])Pattern.values(), (Object)((Object)WHITE_KOI));
        }
    }

    static class KoiEntityGroupData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        final Variant variant;

        KoiEntityGroupData(KoiEntity pLeader, Variant pVariant) {
            super((AbstractSchoolingFish)pLeader);
            this.variant = pVariant;
        }
    }

    public record Variant(Pattern pattern) {
        public int getPackedId() {
            return KoiEntity.packVariant(this.pattern);
        }
    }

    public static enum Base {
        NORMAL(0);

        final int id;

        private Base(int pId) {
            this.id = pId;
        }
    }
}

