/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.forge.model;

import io.github.leonard1504.forge.entity.custom.DoubleFramedBlockEntityForge;
import io.github.leonard1504.util.FetzisAsianDecoQuadHelper;
import io.github.leonard1504.util.FetzisAsianDecoTextureSpriteCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedDoubleFramedModelForge
implements IDynamicBakedModel {
    private final BakedModel baseModel;
    public static final ModelProperty<String> TEXTURE_PROPERTY_1 = new ModelProperty();
    public static final ModelProperty<String> TEXTURE_PROPERTY_2 = new ModelProperty();
    private static final int CACHE_SIZE = 64;
    private static final Map<String, List<BakedQuad>> QUAD_CACHE = new ConcurrentHashMap<String, List<BakedQuad>>();

    public BakedDoubleFramedModelForge(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return List.of();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        TextureAtlasSprite newSprite2;
        String texture1Id = null;
        String texture2Id = null;
        try {
            texture1Id = (String)extraData.get(TEXTURE_PROPERTY_1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (texture1Id == null) {
            return this.baseModel.getQuads(state, side, rand, extraData, renderType);
        }
        try {
            texture2Id = (String)extraData.get(TEXTURE_PROPERTY_2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String cacheKey = BakedDoubleFramedModelForge.stateKey(state) + "#" + BakedDoubleFramedModelForge.renderTypeKey(renderType) + "#" + (side != null ? side.m_122433_() : "null") + "#" + (texture1Id != null ? texture1Id : "null") + "#" + (texture2Id != null ? texture2Id : "null");
        List<BakedQuad> cached = QUAD_CACHE.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        TextureAtlasSprite newSprite1 = FetzisAsianDecoTextureSpriteCache.getCachedTexture(texture1Id);
        if (newSprite1 == null) {
            newSprite1 = FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
        }
        if (texture2Id != null) {
            newSprite2 = FetzisAsianDecoTextureSpriteCache.getCachedTexture(texture2Id);
            if (newSprite2 == null) {
                newSprite2 = FetzisAsianDecoTextureSpriteCache.getPlaceholderSolidSprite();
            }
        } else {
            newSprite2 = FetzisAsianDecoTextureSpriteCache.getPlaceholderSolidSprite();
        }
        List originalQuads = this.baseModel.getQuads(state, side, rand, extraData, renderType);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(originalQuads.size());
        for (BakedQuad quad : originalQuads) {
            BakedQuad transformedQuad;
            if (quad.m_173410_().m_245424_().toString().contains("placeholder_frame") && newSprite1 != null) {
                transformedQuad = this.transformQuad(quad, newSprite1);
                quads.add(transformedQuad);
                continue;
            }
            if (quad.m_173410_().m_245424_().toString().contains("placeholder_solid") && newSprite2 != null) {
                transformedQuad = this.transformQuad(quad, newSprite2);
                quads.add(transformedQuad);
                continue;
            }
            quads.add(quad);
        }
        if (QUAD_CACHE.size() < 64) {
            QUAD_CACHE.put(cacheKey, quads);
        } else if (QUAD_CACHE.size() >= 128) {
            QUAD_CACHE.clear();
        }
        return quads;
    }

    private BakedQuad transformQuad(BakedQuad quad, TextureAtlasSprite newSprite) {
        BakedQuad clonedQuad = FetzisAsianDecoQuadHelper.clone(quad);
        int[] vertexData = clonedQuad.m_111303_();
        for (int vertex = 0; vertex < 4; ++vertex) {
            float u = FetzisAsianDecoQuadHelper.getU(vertexData, vertex);
            float v = FetzisAsianDecoQuadHelper.getV(vertexData, vertex);
            float unInterpolatedU = FetzisAsianDecoQuadHelper.getUnInterpolatedU(quad.m_173410_(), u);
            float unInterpolatedV = FetzisAsianDecoQuadHelper.getUnInterpolatedV(quad.m_173410_(), v);
            FetzisAsianDecoQuadHelper.setU(vertexData, vertex, newSprite.m_118367_((double)unInterpolatedU));
            FetzisAsianDecoQuadHelper.setV(vertexData, vertex, newSprite.m_118393_((double)unInterpolatedV));
        }
        return clonedQuad;
    }

    private static String stateKey(@Nullable BlockState s) {
        if (s == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(BuiltInRegistries.f_256975_.m_7981_((Object)s.m_60734_()).toString());
        s.m_61148_().forEach((p, v) -> sb.append('|').append(p.m_61708_()).append('=').append(String.valueOf(v)));
        return sb.toString();
    }

    private static String renderTypeKey(@Nullable RenderType rt) {
        return rt == null ? "null" : rt.toString();
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DoubleFramedBlockEntityForge) {
            DoubleFramedBlockEntityForge framedBlockEntity = (DoubleFramedBlockEntityForge)blockEntity;
            return framedBlockEntity.getModelData();
        }
        return modelData;
    }

    public static void clearCache() {
        QUAD_CACHE.clear();
    }
}

