/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FetzisAsianDecoTextureSpriteCache {
    private static final Map<String, CachedSprite> TEXTURE_CACHE = new ConcurrentHashMap<String, CachedSprite>();
    private static final Map<String, TextureAtlasSprite> BLOCK_TEXTURE_CACHE = new ConcurrentHashMap<String, TextureAtlasSprite>();
    private static final long CACHE_EXPIRY_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final int MAX_CACHE_SIZE = 256;
    private static long lastCleanup = System.currentTimeMillis();

    public static TextureAtlasSprite getCachedTexture(String textureId) {
        if (textureId == null) {
            return null;
        }
        FetzisAsianDecoTextureSpriteCache.cleanupIfNeeded();
        CachedSprite cached = TEXTURE_CACHE.get(textureId);
        if (cached != null && !cached.isExpired()) {
            return cached.sprite;
        }
        TextureAtlasSprite sprite = FetzisAsianDecoTextureSpriteCache.loadTexture(textureId);
        if (sprite != null) {
            TEXTURE_CACHE.put(textureId, new CachedSprite(sprite));
        }
        return sprite;
    }

    private static TextureAtlasSprite loadTexture(String textureId) {
        try {
            String[] values = textureId.split(":");
            if (values.length != 2) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            ResourceLocation texture = new ResourceLocation(values[0], "block/" + values[1]);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
            if (sprite.m_245424_().m_246162_().toString().contains("missingno")) {
                return FetzisAsianDecoTextureSpriteCache.getFirstTextureFromBlock(textureId);
            }
            return sprite;
        }
        catch (Exception e) {
            System.err.println("[Fetzi's Asian Deco] Error loading texture: " + textureId);
            return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
        }
    }

    public static TextureAtlasSprite getFirstTextureFromBlock(String blockId) {
        TextureAtlasSprite cached = BLOCK_TEXTURE_CACHE.get(blockId);
        if (cached != null) {
            return cached;
        }
        try {
            TextureAtlasSprite sprite;
            String[] values = blockId.split(":");
            if (values.length != 2) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            ResourceLocation blockResource = new ResourceLocation(values[0], values[1]);
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockResource);
            if (block == null || block.m_49966_() == null) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            BlockState defaultState = block.m_49966_();
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(defaultState);
            for (Direction direction : Direction.values()) {
                TextureAtlasSprite sprite2;
                List quads = model.m_213637_(defaultState, direction, RandomSource.m_216327_());
                if (quads.isEmpty() || quads.get(0) == null || (sprite2 = ((BakedQuad)quads.get(0)).m_173410_()) == null) continue;
                BLOCK_TEXTURE_CACHE.put(blockId, sprite2);
                return sprite2;
            }
            List generalQuads = model.m_213637_(defaultState, null, RandomSource.m_216327_());
            if (!generalQuads.isEmpty() && generalQuads.get(0) != null && (sprite = ((BakedQuad)generalQuads.get(0)).m_173410_()) != null) {
                BLOCK_TEXTURE_CACHE.put(blockId, sprite);
                return sprite;
            }
        }
        catch (Exception e) {
            System.err.println("[Fetzi's Asian Deco] Error extracting texture from block: " + blockId);
        }
        return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
    }

    public static TextureAtlasSprite getPlaceholderSprite() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("fetzisasiandeco", "block/placeholder_frame"));
    }

    public static TextureAtlasSprite getPlaceholderSolidSprite() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("fetzisasiandeco", "block/placeholder_solid"));
    }

    private static void cleanupIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - lastCleanup < 30000L) {
            return;
        }
        lastCleanup = now;
        TEXTURE_CACHE.entrySet().removeIf(entry -> ((CachedSprite)entry.getValue()).isExpired());
        if (TEXTURE_CACHE.size() > 256) {
            TEXTURE_CACHE.entrySet().stream().sorted((e1, e2) -> Long.compare(((CachedSprite)e1.getValue()).timestamp, ((CachedSprite)e2.getValue()).timestamp)).limit(TEXTURE_CACHE.size() - 256).forEach(entry -> TEXTURE_CACHE.remove(entry.getKey()));
        }
        if (BLOCK_TEXTURE_CACHE.size() > 256) {
            BLOCK_TEXTURE_CACHE.clear();
        }
    }

    public static void clearCaches() {
        TEXTURE_CACHE.clear();
        BLOCK_TEXTURE_CACHE.clear();
        lastCleanup = System.currentTimeMillis();
    }

    private static class CachedSprite {
        final TextureAtlasSprite sprite;
        final long timestamp;

        CachedSprite(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > CACHE_EXPIRY_MS;
        }
    }
}

